## .vert

uniform float foo;
uniform float foo2;
varying float brightness;

void main()
	{
	vec4 v = gl_Vertex;

	float m = 12.0 / length(v) + foo2;
	v *= vec4( m, m, m, 1.0 );
	
	v.x += sin( m + foo);
	v.y += sin( v.z + foo * 1.1 );
	v.z += sin( v.x + foo * 1.2 );
	v.x += sin( v.z + foo * 1.5 + foo2 );
	v.y += sin( v.x + foo * 1.4 + foo2 * 1.5);
	v.z += sin( v.y + foo * 1.3 + foo2 * 2.0);
	
	vec4 t = vec4( 0.5 + sin( v.x * 0.3 + v.z * 0.28 + foo ), 0.5 + cos( v.y * 0.38 - v.z * 0.22 + foo * 1.2 ), 0.0, 0.0 );
		
	gl_Position = gl_ModelViewProjectionMatrix * v;
	gl_TexCoord[0].stpq = t.stpq;
	brightness = clamp( dot( v, t ), 0.0, 1.0 );
	}

## .frag

uniform sampler2D tex;
varying float brightness;

void main()
	{
	vec4 col = texture2D( tex, gl_TexCoord[0].st ) * brightness;
	gl_FragColor = col;
	}