## .vert

uniform float anim;
varying float alpha;

void main()
	{
	vec4 v = gl_Vertex;

	float speed = 1.5 + sin(v.y);
	v.y += speed * anim;
	v.y = mod(v.y, 10.0) - 5.0;
	v.y *= 10.0;	

	v.x += 0.1 * sin( v.y * 0.9 + anim );
	v.z += 0.1 * cos( v.y + anim * 0.9 );

	alpha = 0.5 + 0.5 * sin( length( v ) * 10.0 );
	
	gl_Position = gl_ModelViewProjectionMatrix * v;
	gl_FrontColor = gl_Color;
	gl_BackColor = gl_Color;
	gl_PointSize = 5.0 - 3.0 * gl_Color.r;
	gl_TexCoord[0].st = gl_MultiTexCoord0.st;
	}

## .frag

uniform sampler2D tex;
varying float alpha;

void main()
	{
	vec4 color = gl_Color * texture2D( tex, gl_TexCoord[0].st );
	color.a *= alpha;
	gl_FragColor = color;
	}