## .vert

uniform float blowy;
uniform float br;

void main()
	{
	vec4 v = gl_Vertex;
	
	float l = min( abs(v.x), abs(v.z) );
	
	vec4 u = vec4(v.x, sin(v.x+v.z), v.z, 0.0);
	u *= pow( 5.0f / ( abs( blowy - v.y ) + 0.1 ), 1.25 );
	v += u;		
		
	v = gl_ModelViewMatrix * v;

	gl_Position = gl_ProjectionMatrix * v;
	gl_PointSize = l * 5.0;
	gl_TexCoord[0].st = gl_MultiTexCoord0.st;
	
	l = l * br;
	vec4 col = vec4( l, l, l * l, 0.5 );
	gl_FrontColor = col;
	gl_BackColor = col;
	}

## .frag

uniform sampler2D tex;

void main()
	{
	vec4 color = gl_Color * texture2D( tex, gl_TexCoord[0].st );
	gl_FragColor = color;
	}