
.org $1001-2
.word $1001

	.word bas_end
	.word 2009
	.byte $de,"1,1:"	;graphic1,1:
	.byte $e0,"1,10,24,",$22,"1K INTRO 4 LIMITED 2",$22,":"
	.byte $9e,"4146",0	;sys4146
bas_end:
	.byte 0,0

COLUMNS = 24

sintab =  $4000
buffer0 = $4800
buffer1 = $4a00
speedcode = $4c00

lines = 16
step = 16

p = $d0
q = $d2

shiftt0 = <(120-2*COLUMNS)
shiftt1 = <(120-COLUMNS)

bitmap = $2000+(40-COLUMNS)/2*8


main:
	sei
	sta $ff3f
		
	lda #$71
	sta $ff19
	
	jsr code_gen

	ldx #0
:	lda sintab_src,x
	sta sintab_src+64,x
	sta sintab,x
	sta sintab+256,x
	inx
	bne :-

	
scen0:	
	jsr loop
	dec count+0
	bne scen0
	
scen1:	
	inc line0+5
	jsr loop

	dec count+1
	bne scen1

scen2:	
	inc line1+5
	jsr loop

	dec count+2
	bne scen2

scen3:	
	jsr loop
	dec count+3
	bne scen3
	
scen4:	
	dec line1+5
	jsr loop

	dec count+4
	bne scen4

scen5:	
	dec line0+5
	jsr loop

	dec count+5
	bne scen5

	inc reminder1
	
endloop:	
	inc line0m+4
	jsr loop
	dec line1m+4
	jsr loop

	jmp endloop

reminder0:
	.byte 1

reminder1:
	.byte 0
	
count:
	.byte 0,3,4,245,4,3
	
loop:
	lda #0
	tax
l5:	sta buffer0,x
	sta buffer0+$0100,x
	sta buffer1,x
	sta buffer1+$0100,x
	inx
	bne l5


;##### line 0
	lda #>buffer0
	sta p+1
	
	ldx #lines
line01d:
	lda #1
	sta p

	bne *+10
	lda buffer0s
	eor #$ff
	sta buffer0s
	
	jsr line0m
	
	clc
	lda line01d+1
linestep0:
	adc #step
	sta line01d+1
	
	lda linestep0+1
linestep0swap:
	eor #16 ^ 16
	sta linestep0+1
	
	
	dex
	bne line01d
	
	clc
	lda line01d+1
	adc reminder0
	sta line01d+1
	
;##### line 1
	
	lda #>buffer1
	sta p+1
	
	ldx #lines
line11d:
	lda #20
	sta p
	
	bne *+10
	lda buffer1s
	eor #$ff
	sta buffer1s

	jsr line1m
	
	clc
	lda line11d+1
linestep1:
	adc #step
	sta line11d+1

	lda linestep1+1
linestep1swap:
	eor #16 ^ 16
	sta linestep1+1
	
	dex
	bne line11d
	
	clc
	lda line11d+1
	adc reminder1
	sta line11d+1

	
;#### fill the buffers

fill:
	ldx #0
buffer0s = *+1
	lda #$ff
	and #$aa
:	eor buffer0,x
	sta buffer0,x
	inx
	bne :-
	
	ldy #40
:	eor buffer0+$100,x
	sta buffer0+$100,x
	inx
	dey
	bpl :-

	ldx #0
buffer1s = *+1
	lda #$00
	and #$55
:	eor buffer1,x
	sta buffer1,x
	inx
	bne :-

	ldy #40
:	eor buffer1+$100,x
	sta buffer1+$100,x
	inx
	dey
	bpl :-

	jmp render_screen_rot

render_screen:

offs0 = *+1
	ldy #0
	ldx #COLUMNS-1

:	lda sintab,y
	sta shiftt1,x
	iny
	dex
	bpl :-

offs1 = *+1
	ldy #12
	ldx #COLUMNS-1

:	lda sintab,y
	sta shiftt0,x
	iny
	dex
	bpl :-

	ldx offs0
	dex
	txa
	and #$3f
	sta offs0

	ldx offs1
	dex
	txa
	and #$3f
	sta offs1
	
	jmp speedcode
	

	.byte 63
render_screen_rot:

	lda #0
	beq incr
	inc render_screen_rot-1
	dec rotv+1
	bne rotv
	dec render_screen_rot+1
	beq rotv
	
incr:	inc rotv+1
	dec render_screen_rot-1
	bne rotv
	inc render_screen_rot+1

rotv:
	ldx #0
	txa
	asl
	asl

	jsr calc_rot
	lda #0
	sta q
	ldy #0
	lda #COLUMNS
:	sta q+1
	sta shiftt0,y
	clc
	lda q
	adc p
	sta q
	lda q+1
	adc p+1
	iny
	cpy #COLUMNS
	bne :-
	
	lda rottab,x
	
	jsr calc_rot
	lda #0
	sta q
	ldy #0
	lda #COLUMNS
:	sta q+1
	sta shiftt1,y
	clc
	lda q
	adc p
	sta q
	lda q+1
	adc p+1
	iny
	cpy #COLUMNS
	bne :-

	jmp speedcode

calc_rot:
	sec
	sbc #128
	sta p
	lda #0
	sbc #0
	asl p
	rol
	sta p+1
	rts
	

line0m:

	ldy p
	clc
	lda sintab,y
	adc sintab+32,y
	;ror
	adc p
	bcc :+
	lda #255
:	sta p
	
line0:

	ldy #3
:	lda (p),y
	eor line0segm,y
	sta (p),y
	dey
	bpl :-
	rts

line0segm:
	.byte $02,$08,$20,$80
	.byte $20,$08,$02

line1m:

	ldy p
	clc
	lda sintab,y
	adc sintab+32,y
	;ror
	adc p
	bcc :+
	lda #255
:	sta p

line1:

	ldy #3
:	lda (p),y
	eor line1segm,y
	sta (p),y
	dey
	bpl :-
	rts

line1segm:
	.byte $40,$10,$04,$01
	.byte $02,$08,$20,$80
	

;###### SPEEDCODE GEN #######	

code_gen:

	lda #<speedcode
	sta p
	lda #>speedcode
	sta p+1
	
l4:
	ldy #8
:	lda code_sample2,y
	sta code_sample,y
	dey
	bpl :-
	
	lda #24
	sta rows
	
	ldy #3
:	lda code_sample3,y
	sta (p),y
	dey
	bpl :-
	clc
	lda p
	adc #4
	sta p
	bcc *+4
	inc p+1
	
l3:	ldx #4
l2:	
	ldy #8
l1:	lda code_sample,y
	sta (p),y
	dey
	bpl l1
	
	inc code_sample+1	
	inc code_sample+4	
	inc code_sample+7	
	inc code_sample+7
	bne *+5
	inc code_sample+8
	
	clc
	lda p
	adc #9
	sta p
	bcc *+4
	inc p+1

	dex
	bne l2

	clc
	lda code_sample+7
	adc #312-256
	sta code_sample+7
	lda code_sample+8
	adc #1
	sta code_sample+8

	dec rows
	bne l3
	
	lda code_sample2+1
	adc #4
	sta code_sample2+1
	bcc *+5
	inc code_sample2+2
	
	clc
	lda code_sample2+7
	adc #8
	sta code_sample2+7
	bcc *+5
	inc code_sample2+8

	sec
	lda code_sample2+4
	sbc #4
	sta code_sample2+4
	bcs *+5
	dec code_sample2+5

	inc code_sample3+1
	inc code_sample3+3
	
	dec cols
	beq :+
	jmp l4
	
:	lda #$60
	ldy #0
	sta (p),y
	rts
	
	
rows:
	.byte 0
cols:
	.byte COLUMNS
	
code_sample:
	lda buffer0
	eor buffer1
	sta bitmap

code_sample2:
	lda buffer0+(5+1)*4,x
	eor buffer1+(5+COLUMNS+1)*4,y
	sta bitmap

code_sample3:
	ldx <shiftt0
	ldy <shiftt1
	
;###### TABLES #######	

rottab:
	.include "rottab.s"
	
sintab_src:
	.include "sintab.s"
	