; rehash
; a 512 byte demo for limiTED2
; by degauss/tek




    processor   6502

	ORG $1001

	incbin "basicline.bin"

charset_template = .-3
	dc.b             $00,$01,$05,$15,$55
	dc.b $55,$55,$55,$55,$54,$50,$40,$00
	dc.b $00,$00,$00,$00



vmem 				EQU $1800	
sintab				EQU $1400	
charset				EQU $D000	
oddbuffer 			EQU $1500
evnbuffer 			EQU $1600


FF1ATAB				EQU $1700
FF1BTAB				EQU $0004

		
twister_bitmapbase	EQU $20
twister_height		EQU $C8


twister_zp			EQU $FE
twister_zpbla		EQU $FC

tmp					EQU $EF

fence_sinpos1		EQU $04

main SUBROUTINE

;----------------------------------------------------------------------
; twister_init
;----------------------------------------------------------------------
twister_init SUBROUTINE
	
	ldy #$a0
	sty $83
	jsr $c5f3
	jsr $c567
	
	lda #$03
	sta $84
	sta $ff06


.lineloop
.linecounter = .+1
	ldy $d0

	sty $02af
	sty $02b3

	lda sintab+64,y
	lsr
;	clc
	adc #32
	sta $02ad
	sta $ff19

	lda #159
	sta $02b1
	
	jsr $c0da
	
	inc $d0
	bne .lineloop

	
.lineok

	SEI		
	STA $FF3F

	
	LDX #$00
	sty $F1
	
	
.loop
	STX FF1BTAB,Y
	stx $ff15
	LDA $F1
	STA FF1ATAB,Y
	sta $ff16

	tya
	and #$07
	cmp #$07
	bne .continue
	
	TXA
	CLC 
	ADC #$28
	TAX
	BCC .continue
	INC $F1
	
.continue
	
	lda #$1b
	sta [vmem + $0000],y
	sta [vmem + $0100],y
	sta [vmem + $0200],y
	sta [vmem + $0300],y
	sta $ff06


	INY
	BNE .loop





	
	


;----------------------------------------------------------------------

fence_prepare_charset SUBROUTINE

.ci_loop2
	
;.ci_deststart = .+1	
;	ldy #$00
	ldy $04
	ldx #$00
.ci_loop	
.tplpos = .+1
	lda charset_template,x
	sta charset,y
	sta charset+1,y
	
	tya
	clc
	adc #$08
	tay
	
	inx
	cpx #$10
	bne .ci_loop
	
	stx $e0
	
	inc .tplpos
	
	
	lda #$02
	sta $ff0b
	sta $ff0a
	clc
	adc $04
	sta $04
	cmp #$08
	bne .ci_loop2


.1
	
	ldy #$00
.0
	tya
	and #$07
	eor #$07
	tax
.mod = .+1	
	lda charset,x
	asl
.source = .+1	
	ora charset,y
.dest = .+1	
	sta charset,y
	
	iny
	bpl .0
	
	clc
	lda .mod
	adc #$08
	sta .mod
	bcc .modok
	inc .mod+1
.modok
	

	lda .dest
	eor #$80
	sta .dest
	bne .destok
	inc .dest+1
.destok	



	dec $e0
	bne .1



;----------------------------------------------------------------------
; fence init
;----------------------------------------------------------------------

fence_init SUBROUTINE
;	lda #$73
;	sta $ff19
;	sta $ff15





;----------------------------------------------------------------------



	
	lda #$98
	sta $ff07

	LDA #twister_irq & 255		
	STA $FFFE						
	LDA #twister_irq >> 8		
	STA $FFFF						
	
fence_do SUBROUTINE

	lda #$00
	sta $d8
	sta $da
	sta $dc

	lda #>oddbuffer
	sta $d9
	sta $db	
	ldx #$08
	jsr fence_calc

	lda #>evnbuffer
	sta $d9	
	ldx #$80
	jsr fence_calc
	
	lda #>[vmem + $0400]
	sta $dd
	sta $da
	
	ldx #$18
	stx $d8
.2
	ldy #$27
.1	
	lda ($da),y
	ora ($d8),y
	sta ($dc),y
	dey
	bpl .1
	
	inc $da
	dec $d8
	
	lda $dc
	clc
	adc #$28
	sta $dc
	bcc .ok
	inc $dd
.ok	
	dex
	bpl .2

	inc $05
	bne fence_do
	

    CLI
	jmp .
	












fence_calc SUBROUTINE

	stx .fence_eor
	txa
	lsr
	sta .fence_add

	
	
	lda fence_sinpos1
	sta .sinptr_current

	lda #$00
	sta $e0
	sta $e1		; maske
	tay
	
.outer_loop

		

.loop	
	lda $e0
	cmp #$20
	bcc .dontskip

	sbc #$20
	sta $e0

	lda $e1
	sta ($d8),y
	jmp .loopend
	
	
.dontskip	
	lsr
	lsr
	lsr

	eor #$03
	
	cpx #$08
	beq .iseven
	asl
	asl
	asl
	asl
.iseven	

	ora $e1
	sta ($d8),y
	clc
.fence_add = .+1
	adc #$04
	iny
	sta ($d8),y	
	

	lda $e1
.fence_eor = .+1	
	eor #$00
	sta $e1


	lda .sinptr_current
	adc #$08
	sta .sinptr_current

.sinptr_current = .+1
	lda sintab
	clc	
	adc $e0
	sta $e0		; pixels until next split

.loopend
	iny
	cpy #$61
	bcc .outer_loop

	inc fence_sinpos1
	rts
	

twister_irq SUBROUTINE

	LDY #$03
.loop

.ptr2 = .+1
	lda sintab
.ptr1 = .+1
	adc sintab+196
.ptr3 = .+1
	adc #$00
	lsr
;	and #$7f
	nop
	tax

	clc

	LDA FF1BTAB+8,X
	STA $FF1B
	LDA FF1ATAB+8,X
	STA $FF1A

	TXA
	AND #$07
	STA $FF1f

	TYA
	AND #$07
	ORA #$38
	STA $ff06

	inc .ptr2

;	NOP

	INY
	CPY #$CB
.loopend	
	BNE .loop

	inc $ff09
	
	inc .ptr3
	dec .ptr1
;	dec .ptr1
	
	ldx tmp
	inx
	stx .ptr2
	stx tmp
	
	RTI	



	echo "EOF: ",[ . - $1001 ]
	
	

	
	
	