/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import vitamin.VStringUtils;

public class VImage {
    public static final int NONE = -1;
    public static final int LUMINANCE = 0;
    public static final int RGB = 1;
    public static final int RGBA = 2;
    public static final int ARGB = 3;
    public static final int ALPHA = 4;
    public static final int BGR = 5;
    public static final int BGRA = 6;
    public static final int LUMINANCE_ALPHA = 7;
    int _width;
    int _height;
    int _format;
    int[] _data;

    public VImage() {
        this._data = null;
        this._height = -1;
        this._width = -1;
        this._format = -1;
        this._format = -1;
    }

    public VImage(int w, int h, int imageFormat) {
        this.createImage(w, h, imageFormat);
    }

    public void release() {
        this._data = null;
        this._width = 0;
        this._height = 0;
        this._format = -1;
    }

    public boolean loadFromFile(String filename) {
        if (filename.endsWith("tga") || filename.endsWith("TGA")) {
            try {
                return this.loadImageTGA(filename);
            }
            catch (IOException e) {
                System.err.println("(VImage)  Failed to load (TGA) image: " + filename);
                return false;
            }
        }
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File(filename));
            this._width = img.getWidth();
            this._height = img.getHeight();
            this._data = new int[this._width * this._height];
            img.getRGB(0, 0, this._width, this._height, this._data, 0, this._width);
            int imageFormat = 0;
            int type = img.getType();
            switch (type) {
                case 2: {
                    imageFormat = 2;
                    System.out.println("(VImage) Image type: RGBA | format: RGBA");
                    break;
                }
                case 3: {
                    imageFormat = 2;
                    System.out.println("(VImage) Image type: ARGB_PRE | format: RGBA");
                    break;
                }
                case 5: {
                    imageFormat = 5;
                    System.out.println("(VImage) Image type: 3BYTE_BGR | format: BGR");
                    break;
                }
                case 6: {
                    imageFormat = 2;
                    System.out.println("(VImage) Image type: 4BYTE_ABGR | format: RGBA");
                    break;
                }
                case 7: {
                    imageFormat = 2;
                    System.out.println("(VImage) Image type: 4BYTE_ABGR_PRE | format: RGBA");
                    break;
                }
                case 4: {
                    imageFormat = 5;
                    System.out.println("(VImage) Image type: BGR | format: RGB");
                    break;
                }
                case 1: {
                    imageFormat = 1;
                    System.out.println("(VImage) Image type: RGB | format: RGB");
                    break;
                }
                case 10: {
                    imageFormat = 0;
                    System.out.println("(VImage) Image type: LUMINANCE | format: LUMINANCE");
                    break;
                }
                case 0: {
                    imageFormat = 6;
                    System.out.println("(VImage) Image type: CUSTOM | format: BGRA");
                    break;
                }
                default: {
                    System.err.println("(VImage) Image type: UNKNOWN");
                    imageFormat = -1;
                }
            }
            this._format = imageFormat;
            return true;
        }
        catch (IOException e) {
            System.err.println("(VImage)  Failed to load image: " + filename);
            return false;
        }
    }

    public void createImage(int w, int h, int imageFormat) {
        this._width = w;
        this._height = h;
        this._data = new int[w * h];
        this._format = imageFormat;
    }

    protected boolean loadImageTGA(String filename) throws IOException {
        int format;
        block47: {
            boolean reversed;
            int h;
            int w;
            InputStream is;
            block45: {
                block46: {
                    int count;
                    is = this.createInput(filename);
                    if (is == null) {
                        return false;
                    }
                    byte[] header = new byte[18];
                    int offset = 0;
                    do {
                        if ((count = is.read(header, offset, header.length - offset)) != -1) continue;
                        return false;
                    } while ((offset += count) < 18);
                    format = 0;
                    if (!(header[2] != 3 && header[2] != 11 || header[16] != 8 || header[17] != 8 && header[17] != 40)) {
                        format = 4;
                    } else if (!(header[2] != 2 && header[2] != 10 || header[16] != 24 || header[17] != 32 && header[17] != 0)) {
                        format = 1;
                    } else if (!(header[2] != 2 && header[2] != 10 || header[16] != 32 || header[17] != 8 && header[17] != 40)) {
                        format = 3;
                    }
                    if (format == 0) {
                        System.err.println("Unknown .tga file format for " + filename);
                        return false;
                    }
                    w = ((header[13] & 0xFF) << 8) + (header[12] & 0xFF);
                    h = ((header[15] & 0xFF) << 8) + (header[14] & 0xFF);
                    this.createImage(w, h, format);
                    boolean bl = reversed = (header[17] & 0x20) != 0;
                    if (header[2] != 2 && header[2] != 3) break block45;
                    if (!reversed) break block46;
                    int index = (h - 1) * w;
                    switch (format) {
                        case 4: {
                            int y = h - 1;
                            while (y >= 0) {
                                int x = 0;
                                while (x < w) {
                                    this._data[index + x] = is.read();
                                    ++x;
                                }
                                index -= w;
                                --y;
                            }
                            break block47;
                        }
                        case 1: {
                            int y = h - 1;
                            while (y >= 0) {
                                int x = 0;
                                while (x < w) {
                                    this._data[index + x] = is.read() | is.read() << 8 | is.read() << 16 | 0xFF000000;
                                    ++x;
                                }
                                index -= w;
                                --y;
                            }
                            break block47;
                        }
                        case 3: {
                            int y = h - 1;
                            while (y >= 0) {
                                int x = 0;
                                while (x < w) {
                                    this._data[index + x] = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                                    ++x;
                                }
                                index -= w;
                                --y;
                            }
                            break block0;
                        }
                    }
                    break block47;
                }
                int count = w * h;
                switch (format) {
                    case 4: {
                        int i = 0;
                        while (i < count) {
                            this._data[i] = is.read();
                            ++i;
                        }
                        break block47;
                    }
                    case 1: {
                        int i = 0;
                        while (i < count) {
                            this._data[i] = is.read() | is.read() << 8 | is.read() << 16 | 0xFF000000;
                            ++i;
                        }
                        break block47;
                    }
                    case 3: {
                        int i = 0;
                        while (i < count) {
                            this._data[i] = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                            ++i;
                        }
                        break block5;
                    }
                }
                break block47;
            }
            int index = 0;
            int[] px = this._data;
            block30: while (index < px.length) {
                boolean isRLE;
                int num = is.read();
                boolean bl = isRLE = (num & 0x80) != 0;
                if (isRLE) {
                    num -= 127;
                    int pixel = 0;
                    switch (format) {
                        case 4: {
                            pixel = is.read();
                            break;
                        }
                        case 1: {
                            pixel = 0xFF000000 | is.read() | is.read() << 8 | is.read() << 16;
                            break;
                        }
                        case 3: {
                            pixel = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                        }
                    }
                    int i = 0;
                    while (i < num) {
                        px[index++] = pixel;
                        if (index == px.length) continue block30;
                        ++i;
                    }
                    continue;
                }
                ++num;
                switch (format) {
                    case 4: {
                        int i = 0;
                        while (i < num) {
                            px[index++] = is.read();
                            ++i;
                        }
                        continue block30;
                    }
                    case 1: {
                        int i = 0;
                        while (i < num) {
                            px[index++] = 0xFF000000 | is.read() | is.read() << 8 | is.read() << 16;
                            ++i;
                        }
                        continue block30;
                    }
                    case 3: {
                        int i = 0;
                        while (i < num) {
                            px[index++] = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                            ++i;
                        }
                        continue block30;
                    }
                }
            }
            if (!reversed) {
                int[] temp = new int[w];
                int y = 0;
                while (y < h / 2) {
                    int z = h - 1 - y;
                    System.arraycopy(px, y * w, temp, 0, w);
                    System.arraycopy(px, z * w, px, y * w, w);
                    System.arraycopy(temp, 0, px, z * w, w);
                    ++y;
                }
            }
        }
        this._format = format;
        return true;
    }

    InputStream createInput(String filename) {
        try {
            try {
                FileInputStream stream;
                try {
                    stream = new FileInputStream(VStringUtils.dataPath(filename));
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    stream = new FileInputStream(filename);
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (SecurityException securityException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setData(int[] data) {
        System.arraycopy(data, 0, this._data, 0, this._width * this._height);
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getFormat() {
        return this._format;
    }

    public int[] getData() {
        return this._data;
    }

    public int[] pixels() {
        return this._data;
    }
}

