/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import java.util.ArrayList;
import vitamin.math.Vector3;
import vitamin.scenesimple.Mesh;
import vitamin.scenesimple.Triangle;
import vitamin.scenesimple.Vertex;

public class MeshSphere
extends Mesh {
    float _uMulti;
    float _vMulti;
    Vector3 _center;
    int _rings;
    int _segments;
    float _radius;

    public MeshSphere(String name, float r, int detail) {
        this._name = name;
        this._vertexList = new ArrayList();
        this._triangleList = new ArrayList();
        this._vMulti = 1.0f;
        this._uMulti = 1.0f;
        this._hasTriStrip = false;
        this.setCenter(new Vector3(0.0f, 0.0f, 0.0f));
        this.setRadius(r);
        this.setDetail(detail, detail);
    }

    public MeshSphere(String name, Vector3 center, float r, int detail) {
        this._name = name;
        this._vertexList = new ArrayList();
        this._triangleList = new ArrayList();
        this._vMulti = 1.0f;
        this._uMulti = 1.0f;
        this._hasTriStrip = false;
        this.setCenter(center);
        this.setRadius(r);
        this.setDetail(detail, detail);
    }

    public MeshSphere(String name, Vector3 center, float r, int rings, int segments) {
        this._name = name;
        this._vertexList = new ArrayList();
        this._triangleList = new ArrayList();
        this._vMulti = 1.0f;
        this._uMulti = 1.0f;
        this._hasTriStrip = false;
        this.setCenter(center);
        this.setRadius(r);
        this.setDetail(rings, segments);
    }

    public void setUVMultiplier(float um, float vm) {
        this._uMulti = um;
        this._vMulti = vm;
    }

    public void setRadius(float r) {
        this._radius = r;
    }

    public void setCenter(Vector3 center) {
        this._center = center;
    }

    public void setDetail(int rings, int segments) {
        this._rings = rings;
        this._segments = segments;
    }

    public boolean generate() {
        float fDeltaRingAngle = (float)(Math.PI / (double)this._rings);
        float fDeltaSegAngle = (float)(Math.PI * 2 / (double)this._segments);
        int ring = 0;
        while (ring < this._rings + 1) {
            float r0 = (float)Math.sin((float)(ring + 0) * fDeltaRingAngle);
            float y0 = (float)Math.cos((float)(ring + 0) * fDeltaRingAngle);
            int seg = 0;
            while (seg < this._segments + 1) {
                float x0 = r0 * (float)Math.sin((float)seg * fDeltaSegAngle);
                float z0 = r0 * (float)Math.cos((float)seg * fDeltaSegAngle);
                Vertex v1 = new Vertex();
                v1._position.set(x0 * this._radius, y0 * this._radius, z0 * this._radius);
                v1._position.add(this._center);
                v1._normal.set(x0, y0, z0);
                v1._normal.normalize();
                float x = v1._normal.x;
                float y = v1._normal.y;
                float z = v1._normal.z;
                if (x < y && x < z) {
                    v1._tangent.set(0.0f, -z, y);
                } else if (y < x && y < z) {
                    v1._tangent.set(-z, 0.0f, x);
                } else if (z < x && z < y) {
                    v1._tangent.set(-y, x, 0.0f);
                }
                v1._tangent.normalize();
                v1._tangent = Vector3.cross(v1._normal, v1._tangent);
                v1._texCoord.x = (float)seg / (float)this._segments * this._uMulti;
                v1._texCoord.y = (float)(ring + 0) / (float)this._rings * this._vMulti;
                this._vertexList.add(v1);
                ++seg;
            }
            ++ring;
        }
        if (this._triStripList == null) {
            this._triStripList = new int[(this._rings + 1) * this._segments * 2];
        }
        int index = 0;
        int ring2 = 0;
        while (ring2 < this._rings) {
            int idx = ring2 * this._rings;
            int idx2 = (ring2 + 1) * this._rings;
            int seg = 0;
            while (seg < this._segments) {
                this._triStripList[index + 0] = idx + seg;
                this._triStripList[index + 1] = idx2 + seg;
                index += 2;
                ++seg;
            }
            ++ring2;
        }
        int i = 2;
        while (i < this._triStripList.length) {
            Triangle tri = new Triangle();
            if (i % 2 == 0) {
                tri._a = this._triStripList[i - 2];
                tri._b = this._triStripList[i - 1];
                tri._c = this._triStripList[i - 0];
                this._triangleList.add(tri);
            } else {
                tri._a = this._triStripList[i - 0];
                tri._b = this._triStripList[i - 1];
                tri._c = this._triStripList[i - 2];
                this._triangleList.add(tri);
            }
            ++i;
        }
        this._hasNormals = true;
        this._hasTangents = true;
        System.out.println("Generated sphere with: '" + this._vertexList.size() + "' vertices and '" + this._triangleList.size() + "' triangles");
        return true;
    }
}

