/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.Obuffer;
import javazoom.jl.decoder.SynthesisFilter;

class LayerIDecoder
implements FrameDecoder {
    protected Bitstream stream;
    protected Header header;
    protected SynthesisFilter filter1;
    protected SynthesisFilter filter2;
    protected Obuffer buffer;
    protected int which_channels;
    protected int mode;
    protected int num_subbands;
    protected Subband[] subbands;
    protected Crc16 crc = new Crc16();

    public void create(Bitstream bitstream, Header header, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2, Obuffer obuffer, int n) {
        this.stream = bitstream;
        this.header = header;
        this.filter1 = synthesisFilter;
        this.filter2 = synthesisFilter2;
        this.buffer = obuffer;
        this.which_channels = n;
    }

    public void decodeFrame() {
        this.num_subbands = this.header.number_of_subbands();
        this.subbands = new Subband[32];
        this.mode = this.header.mode();
        this.createSubbands();
        this.readAllocation();
        this.readScaleFactorSelection();
        if (this.crc != null || this.header.checksum_ok()) {
            this.readScaleFactors();
            this.readSampleData();
        }
    }

    protected void createSubbands() {
        if (this.mode == 3) {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer1(i);
            }
        } else if (this.mode == 1) {
            int n;
            for (n = 0; n < this.header.intensity_stereo_bound(); ++n) {
                this.subbands[n] = new SubbandLayer1Stereo(n);
            }
            while (n < this.num_subbands) {
                this.subbands[n] = new SubbandLayer1IntensityStereo(n);
                ++n;
            }
        } else {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer1Stereo(i);
            }
        }
    }

    protected void readAllocation() {
        for (int i = 0; i < this.num_subbands; ++i) {
            this.subbands[i].read_allocation(this.stream, this.header, this.crc);
        }
    }

    protected void readScaleFactorSelection() {
    }

    protected void readScaleFactors() {
        for (int i = 0; i < this.num_subbands; ++i) {
            this.subbands[i].read_scalefactor(this.stream, this.header);
        }
    }

    protected void readSampleData() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.header.mode();
        do {
            int n2;
            for (n2 = 0; n2 < this.num_subbands; ++n2) {
                bl = this.subbands[n2].read_sampledata(this.stream);
            }
            do {
                for (n2 = 0; n2 < this.num_subbands; ++n2) {
                    bl2 = this.subbands[n2].put_next_sample(this.which_channels, this.filter1, this.filter2);
                }
                this.filter1.calculate_pcm_samples(this.buffer);
                if (this.which_channels != 0 || n == 3) continue;
                this.filter2.calculate_pcm_samples(this.buffer);
            } while (!bl2);
        } while (!bl);
    }
}

