/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import com.sun.opengl.cg.CGcontext;
import com.sun.opengl.cg.CGparameter;
import com.sun.opengl.cg.CGprogram;
import com.sun.opengl.cg.CgGL;
import javax.media.opengl.GL;
import vitamin.Shader;

public class ShaderCG
extends Shader {
    public static final int VERTEX = 0;
    public static final int FRAGMENT = 1;
    public static final int GEOMETRY = 2;
    CGcontext _context;
    int vertexProfile;
    int fragmentProfile;
    int geometryProfile;
    CGprogram _currProgram;
    CGprogram vertexProgram;
    CGprogram fragmentProgram;
    CGprogram geometryProgram;

    public ShaderCG(GL gl, String name) {
        this._gl = gl;
        this._type = 1;
        this._name = name;
        this._context = CgGL.cgCreateContext();
        CgGL.cgGLRegisterStates((CGcontext)this._context);
        CgGL.cgGLSetManageTextureParameters((CGcontext)this._context, (boolean)true);
        this.vertexProgram = null;
        this.fragmentProgram = null;
        this.geometryProgram = null;
        this._currProgram = null;
    }

    public void checkProfiles() {
        if (CgGL.cgGLIsProfileSupported((int)6150)) {
            this.vertexProfile = 6150;
            System.out.println("CG_PROFILE_ARBVP1 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)7001)) {
            this.vertexProfile = 7001;
            System.out.println("CG_PROFILE_VP40 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6148)) {
            this.vertexProfile = 6148;
            System.out.println("CG_PROFILE_VP30 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6146)) {
            this.vertexProfile = 6146;
            System.out.println("CG_PROFILE_VP20 supported");
        }
        if (CgGL.cgGLIsProfileSupported((int)7000)) {
            this.fragmentProfile = 7000;
            System.out.println("CG_PROFILE_ARBFP1 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6151)) {
            this.fragmentProfile = 6151;
            System.out.println("CG_PROFILE_FP40 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6149)) {
            this.fragmentProfile = 6149;
            System.out.println("CG_PROFILE_FP30 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6147)) {
            this.fragmentProfile = 6147;
            System.out.println("CG_PROFILE_FP20 supported");
        }
    }

    public void load(String vfile, String ffile) {
        if (vfile != null) {
            this.loadVertexShader(vfile);
        }
        if (ffile != null) {
            this.loadFragmentShader(ffile);
        }
        this.compile();
        this._currProgram = this.vertexProgram;
    }

    public void load(String vfile, String ffile, String gfile) {
        if (vfile != null) {
            this.loadVertexShader(vfile);
        }
        if (ffile != null) {
            this.loadFragmentShader(ffile);
        }
        if (gfile != null) {
            this.loadGeometryShader(gfile);
        }
        this.compile();
        this._currProgram = this.vertexProgram;
    }

    boolean loadVertexShader(String file) {
        this.vertexProfile = CgGL.cgGLGetLatestProfile((int)8);
        if (this.vertexProfile == 6145) {
            System.out.println("(ShaderCG)  Vertex profile could not be created");
        } else {
            CgGL.cgGLSetOptimalOptions((int)this.vertexProfile);
        }
        this.vertexProgram = CgGL.cgCreateProgramFromFile((CGcontext)this._context, (int)4112, (String)file, (int)this.vertexProfile, null, null);
        this.checkErrorInfo(file, this.vertexProgram);
        boolean bl = this._vertexShaderEnabled = this.vertexProgram != null && this.vertexProfile != 6145;
        if (this._vertexShaderEnabled) {
            System.out.println("(ShaderCG)  Loaded vertex program: " + file);
        } else {
            System.out.println("(ShaderCG)  Failed to loaded vertex program: " + file);
        }
        return this._vertexShaderEnabled;
    }

    boolean loadFragmentShader(String file) {
        this.fragmentProfile = CgGL.cgGLGetLatestProfile((int)9);
        if (this.fragmentProfile == 6145) {
            System.err.println("(ShaderCG)  Fragment profile could not be created");
        } else {
            CgGL.cgGLSetOptimalOptions((int)this.fragmentProfile);
        }
        this.fragmentProgram = CgGL.cgCreateProgramFromFile((CGcontext)this._context, (int)4112, (String)file, (int)this.fragmentProfile, null, null);
        this.checkErrorInfo(file, this.fragmentProgram);
        boolean bl = this._fragmentShaderEnabled = this.fragmentProgram != null && this.fragmentProfile != 6145;
        if (this._fragmentShaderEnabled) {
            System.out.println("(ShaderCG)  Loaded fragment program: " + file);
        } else {
            System.err.println("(ShaderCG)  Failed to loaded fragment program: " + file);
        }
        return this._fragmentShaderEnabled;
    }

    boolean loadGeometryShader(String file) {
        this.geometryProgram = CgGL.cgCreateProgramFromFile((CGcontext)this._context, (int)4112, (String)file, (int)7000, null, null);
        this.checkErrorInfo(file, this.geometryProgram);
        boolean bl = this._geometryShaderEnabled = this.geometryProgram != null && this.geometryProfile != 6145;
        if (this._geometryShaderEnabled) {
            System.out.println("(ShaderCG)  Loaded geometry program: " + file);
        } else {
            System.err.println("(ShaderCG)  Failed to loaded geometry program: " + file);
        }
        return this._geometryShaderEnabled;
    }

    public void compile() {
        if (this._vertexShaderEnabled) {
            CgGL.cgGLLoadProgram((CGprogram)this.vertexProgram);
        }
        if (this._fragmentShaderEnabled) {
            CgGL.cgGLLoadProgram((CGprogram)this.fragmentProgram);
        }
        if (this._geometryShaderEnabled) {
            CgGL.cgGLLoadProgram((CGprogram)this.geometryProgram);
        }
    }

    public void enable() {
        if (this._vertexShaderEnabled) {
            CgGL.cgGLBindProgram((CGprogram)this.vertexProgram);
            CgGL.cgGLEnableProfile((int)this.vertexProfile);
        }
        if (this._fragmentShaderEnabled) {
            CgGL.cgGLBindProgram((CGprogram)this.fragmentProgram);
            CgGL.cgGLEnableProfile((int)this.fragmentProfile);
        }
        if (this._geometryShaderEnabled) {
            CgGL.cgGLBindProgram((CGprogram)this.geometryProgram);
            CgGL.cgGLEnableProfile((int)this.geometryProfile);
        }
    }

    public void disable() {
        if (this._vertexShaderEnabled) {
            CgGL.cgGLDisableProfile((int)this.vertexProfile);
        }
        if (this._fragmentShaderEnabled) {
            CgGL.cgGLDisableProfile((int)this.fragmentProfile);
        }
        if (this._geometryShaderEnabled) {
            CgGL.cgGLDisableProfile((int)this.geometryProfile);
        }
    }

    void setProgram(int p) {
        switch (p) {
            case 0: {
                this._currProgram = this.vertexProgram;
                break;
            }
            case 1: {
                this._currProgram = this.fragmentProgram;
                break;
            }
            case 2: {
                this._currProgram = this.geometryProgram;
                break;
            }
            default: {
                this._currProgram = this.vertexProgram;
            }
        }
    }

    public void setTextureParameter(String param, int val) {
    }

    public void setParameter1d(String param, double x) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetParameter1f((CGparameter)p, (float)((float)x));
        }
    }

    public void setParameter1f(String param, float x) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetParameter1f((CGparameter)p, (float)x);
        }
    }

    public void setParameter1i(String param, int x) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetParameter1i((CGparameter)p, (int)x);
        }
    }

    public void setParameter2f(String param, float x, float y) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetParameter2f((CGparameter)p, (float)x, (float)y);
        }
    }

    public void setParameter2i(String param, int x, int y) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetParameter2i((CGparameter)p, (int)x, (int)y);
        }
    }

    public void setParameter3f(String param, float x, float y, float z) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetParameter3f((CGparameter)p, (float)x, (float)y, (float)z);
        }
    }

    public void setParameter3fv(String param, float[] v) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetParameter3fv((CGparameter)p, (float[])v, (int)0);
        }
    }

    public void setParameter4f(String param, float x, float y, float z, float w) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetParameter4f((CGparameter)p, (float)x, (float)y, (float)z, (float)w);
        }
    }

    public void setParameter4fv(String param, float[] v) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetParameter4fv((CGparameter)p, (float[])v, (int)0);
        }
    }

    public void setMatrixParameterSemantic(String param, int matrix, int matrixType) {
        System.err.println("(ShaderCG)  'setMatrixParameterSemantic( String param, int matrix, int matrixType )' isnt supported by Cg Shaders");
    }

    public void setMatrixParameterSemantic(String param, float[] v) {
        System.err.println("(ShaderCG)  'setMatrixParameterSemantic( String param, float[] v )' isnt supported by Cg Shaders");
    }

    public void setParameterSemantic(String param, float x) {
    }

    public void setParameterSemantic(String param, float x, float y) {
    }

    public void setParameterSemantic(String param, float x, float y, float z) {
    }

    public void setParameterSemantic(String param, float x, float y, float z, float w) {
        System.err.println("(ShaderCG)  'setParameterSemantic( String param, float x, float y, float z, float w )' isnt supported by Cg Shaders");
    }

    public void setParameter4x4d(String param, double[] v) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetMatrixParameterdr((CGparameter)p, (double[])v, (int)0);
        }
    }

    public void setParameter4x4f(String param, float[] v) {
        CGparameter p = CgGL.cgGetNamedParameter((CGprogram)this._currProgram, (String)param);
        if (p != null) {
            CgGL.cgSetMatrixParameterfr((CGparameter)p, (float[])v, (int)0);
        }
    }

    public void setParameter4x4f(String semanticName, int matrix, int matrixType) {
        System.err.println("(ShaderCG)  'setParameter4x4f( String semanticName, int matrix, int matrixType )' isnt supported by Cg Shaders");
    }

    public void setParameter4x4fBySemantic(String semanticName, int matrix, int matrixType) {
        System.err.println("(ShaderCG)  'setParameter4x4fBySemantic( String semanticName, int matrix, int matrixType )' isnt supported by Cg Shaders");
    }

    private void checkErrorInfo(String fn, CGprogram program) {
        if (program == null) {
            int error = CgGL.cgGetError();
            System.out.println("(ShaderCG)  Cg error(s) in " + fn);
            System.out.println("(ShaderCG)  " + CgGL.cgGetErrorString((int)error));
            System.out.println("(ShaderCG)  " + CgGL.cgGetLastListing((CGcontext)this._context));
        }
    }

    public void release() {
        if (this._vertexShaderEnabled) {
            CgGL.cgDestroyProgram((CGprogram)this.vertexProgram);
        }
        if (this._fragmentShaderEnabled) {
            CgGL.cgDestroyProgram((CGprogram)this.fragmentProgram);
        }
        if (this._geometryShaderEnabled) {
            CgGL.cgDestroyProgram((CGprogram)this.geometryProgram);
        }
        if (this._context != null) {
            CgGL.cgDestroyContext((CGcontext)this._context);
        }
    }
}

