/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import vitamin.math.Matrix;
import vitamin.math.Vector2;

public class Vector3 {
    public static final Vector3 UP = new Vector3(0.0f, 1.0f, 0.0f);
    public static final Vector3 DOWN = new Vector3(0.0f, -1.0f, 0.0f);
    public static final Vector3 LEFT = new Vector3(-1.0f, 0.0f, 0.0f);
    public static final Vector3 RIGHT = new Vector3(1.0f, 0.0f, 0.0f);
    public static final Vector3 ONE = new Vector3(1.0f, 1.0f, 1.0f);
    public static final Vector3 ZERO = new Vector3(0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float z;

    public Vector3() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector3(float xx, float yy, float zz) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public Vector3(Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void set(float xx, float yy, float zz) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public void set(Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void reset() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector3 copy() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Vector2 xy() {
        return new Vector2(this.x, this.y);
    }

    public void add(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void sub(Vector3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public void sub(float x, float y, float z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
    }

    public Vector3 minus(Vector3 v) {
        Vector3 tmp = new Vector3();
        tmp.x = this.x - v.x;
        tmp.y = this.y - v.y;
        tmp.z = this.z - v.z;
        return tmp;
    }

    public void mul(Vector3 v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
    }

    public void div(Vector3 v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
    }

    public void mul(float s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
    }

    public void div(float s) {
        this.x /= s;
        this.y /= s;
        this.z /= s;
    }

    public float dot(Vector3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector3 cross(Vector3 v) {
        float crossX = this.y * v.z - v.y * this.z;
        float crossY = this.z * v.x - v.z * this.x;
        float crossZ = this.x * v.y - v.x * this.y;
        return new Vector3(crossX, crossY, crossZ);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float lengthXY() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void normalize() {
        float m = this.length();
        if (m > 0.0f) {
            this.div(m);
        }
    }

    public boolean SetCatmullRom(Vector3 V1, Vector3 V2, Vector3 V3, Vector3 V4, float s) {
        float ss = s * s;
        float sss = s * ss;
        float a = -0.5f * sss + ss - 0.5f * s;
        float b = 1.5f * sss - 2.5f * ss + 1.0f;
        float c = -1.5f * sss + 2.0f * ss + 0.5f * s;
        float d = 0.5f * sss - 0.5f * ss;
        this.x = a * V1.x + b * V2.x + c * V3.x + d * V4.x;
        this.y = a * V1.y + b * V2.y + c * V3.y + d * V4.y;
        this.z = a * V1.z + b * V2.z + c * V3.z + d * V4.z;
        return true;
    }

    public boolean SetHermite(Vector3 V1, Vector3 T1, Vector3 V2, Vector3 T2, float s) {
        float ss = s * s;
        float sss = s * ss;
        float a = 2.0f * sss - 3.0f * ss + 1.0f;
        float b = -2.0f * sss + 3.0f * ss;
        float c = sss - 2.0f * ss + s;
        float d = sss - ss;
        this.x = a * V1.x + b * V2.x + c * T1.x + d * T2.x;
        this.y = a * V1.y + b * V2.y + c * T1.y + d * T2.y;
        this.z = a * V1.z + b * V2.z + c * T1.z + d * T2.z;
        return true;
    }

    public boolean SetBaryCentric(Vector3 V1, Vector3 V2, Vector3 V3, float f, float g) {
        this.x = V1.x + f * (V2.x - V1.x) + g * (V3.x - V1.x);
        this.y = V1.y + f * (V2.y - V1.y) + g * (V3.y - V1.y);
        this.z = V1.z + f * (V2.z - V1.z) + g * (V3.z - V1.z);
        return true;
    }

    public Vector3 lerp(Vector3 V1, float s) {
        return new Vector3(this.x + s * (V1.x - this.x), this.y + s * (V1.y - this.y), this.z + s * (V1.z - this.z));
    }

    public void transform(Matrix m) {
        float xx = this.x * m._M[0] + this.y * m._M[4] + this.z * m._M[8] + m._M[12];
        float yy = this.x * m._M[1] + this.y * m._M[5] + this.z * m._M[9] + m._M[13];
        float zz = this.x * m._M[2] + this.y * m._M[6] + this.z * m._M[10] + m._M[14];
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public void transformNormal(Matrix m) {
        float xx = this.x * m._M[0] + this.y * m._M[4] + this.z * m._M[8];
        float yy = this.x * m._M[1] + this.y * m._M[5] + this.z * m._M[9];
        float zz = this.x * m._M[2] + this.y * m._M[6] + this.z * m._M[10];
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public static Vector3 add(Vector3 a, Vector3 b) {
        return new Vector3(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vector3 sub(Vector3 a, Vector3 b) {
        return new Vector3(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Vector3 mul(Vector3 a, Vector3 b) {
        return new Vector3(a.x * b.x, a.y * b.y, a.z * b.z);
    }

    public static Vector3 mul(Vector3 a, float f) {
        return new Vector3(a.x * f, a.y * f, a.z * f);
    }

    public static float dot(Vector3 v1, Vector3 v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public static Vector3 cross(Vector3 a, Vector3 b) {
        float crossX = a.y * b.z - b.y * a.z;
        float crossY = a.z * b.x - b.z * a.x;
        float crossZ = a.x * b.y - b.x * a.y;
        return new Vector3(crossX, crossY, crossZ);
    }

    public static float distance(Vector3 v1, Vector3 v2) {
        float dx = v1.x - v2.x;
        float dy = v1.y - v2.y;
        float dz = v1.z - v2.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static float distanceSqr(Vector3 v1, Vector3 v2) {
        float dx = v1.x - v2.x;
        float dy = v1.y - v2.y;
        float dz = v1.z - v2.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static float angleBetween(Vector3 v1, Vector3 v2) {
        float dot = v1.dot(v2);
        float theta = (float)Math.acos(dot / (v1.length() * v2.length()));
        return theta;
    }

    public static Vector3 transform(Vector3 v, Matrix m) {
        float xx = v.x * m._M[0] + v.y * m._M[4] + v.z * m._M[8] + m._M[12];
        float yy = v.x * m._M[1] + v.y * m._M[5] + v.z * m._M[9] + m._M[13];
        float zz = v.x * m._M[2] + v.y * m._M[6] + v.z * m._M[10] + m._M[14];
        return new Vector3(xx, yy, zz);
    }

    public static Vector3 transformNormal(Vector3 v, Matrix m) {
        float xx = v.x * m._M[0] + v.y * m._M[4] + v.z * m._M[8];
        float yy = v.x * m._M[1] + v.y * m._M[5] + v.z * m._M[9];
        float zz = v.x * m._M[2] + v.y * m._M[6] + v.z * m._M[10];
        return new Vector3(xx, yy, zz);
    }

    public static Vector3 lerp(Vector3 v0, Vector3 v1, float t) {
        return new Vector3(v0.x + (v1.x - v0.x) * t, v0.y + (v1.y - v0.y) * t, v0.z + (v1.z - v0.z) * t);
    }

    public static Vector3 ZERO() {
        return new Vector3(0.0f, 0.0f, 0.0f);
    }

    public float[] getArray() {
        float[] b = new float[]{this.x, this.y, this.z};
        return b;
    }

    public void debug() {
        System.out.println(String.valueOf(this.x) + ", " + this.y + ", " + this.z);
    }

    public String toString() {
        return new String(String.valueOf(this.x) + ", " + this.y + ", " + this.z);
    }
}

