/*
 * Decompiled with CFR 0.152.
 */
package quickhull3d;

import quickhull3d.Vertex;

class VertexList {
    private Vertex head;
    private Vertex tail;

    VertexList() {
    }

    public void clear() {
        this.tail = null;
        this.head = null;
    }

    public void add(Vertex vertex) {
        if (this.head == null) {
            this.head = vertex;
        } else {
            this.tail.next = vertex;
        }
        vertex.prev = this.tail;
        vertex.next = null;
        this.tail = vertex;
    }

    public void addAll(Vertex vertex) {
        if (this.head == null) {
            this.head = vertex;
        } else {
            this.tail.next = vertex;
        }
        vertex.prev = this.tail;
        while (vertex.next != null) {
            vertex = vertex.next;
        }
        this.tail = vertex;
    }

    public void delete(Vertex vertex) {
        if (vertex.prev == null) {
            this.head = vertex.next;
        } else {
            vertex.prev.next = vertex.next;
        }
        if (vertex.next == null) {
            this.tail = vertex.prev;
        } else {
            vertex.next.prev = vertex.prev;
        }
    }

    public void delete(Vertex vertex, Vertex vertex2) {
        if (vertex.prev == null) {
            this.head = vertex2.next;
        } else {
            vertex.prev.next = vertex2.next;
        }
        if (vertex2.next == null) {
            this.tail = vertex.prev;
        } else {
            vertex2.next.prev = vertex.prev;
        }
    }

    public void insertBefore(Vertex vertex, Vertex vertex2) {
        vertex.prev = vertex2.prev;
        if (vertex2.prev == null) {
            this.head = vertex;
        } else {
            vertex2.prev.next = vertex;
        }
        vertex.next = vertex2;
        vertex2.prev = vertex;
    }

    public Vertex first() {
        return this.head;
    }

    public boolean isEmpty() {
        return this.head == null;
    }
}

