/*
 * Decompiled with CFR 0.152.
 */
package quickhull3d;

import java.util.Random;

public class Vector3d {
    private static final double DOUBLE_PREC = 2.220446049250313E-16;
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(Vector3d vector3d) {
        this.set(vector3d);
    }

    public Vector3d(double d, double d2, double d3) {
        this.set(d, d2, d3);
    }

    public double get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public void set(int n, double d) {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(n);
            }
        }
    }

    public void set(Vector3d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    public void add(Vector3d vector3d, Vector3d vector3d2) {
        this.x = vector3d.x + vector3d2.x;
        this.y = vector3d.y + vector3d2.y;
        this.z = vector3d.z + vector3d2.z;
    }

    public void add(Vector3d vector3d) {
        this.x += vector3d.x;
        this.y += vector3d.y;
        this.z += vector3d.z;
    }

    public void sub(Vector3d vector3d, Vector3d vector3d2) {
        this.x = vector3d.x - vector3d2.x;
        this.y = vector3d.y - vector3d2.y;
        this.z = vector3d.z - vector3d2.z;
    }

    public void sub(Vector3d vector3d) {
        this.x -= vector3d.x;
        this.y -= vector3d.y;
        this.z -= vector3d.z;
    }

    public void scale(double d) {
        this.x = d * this.x;
        this.y = d * this.y;
        this.z = d * this.z;
    }

    public void scale(double d, Vector3d vector3d) {
        this.x = d * vector3d.x;
        this.y = d * vector3d.y;
        this.z = d * vector3d.z;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double normSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distance(Vector3d vector3d) {
        double d = this.x - vector3d.x;
        double d2 = this.y - vector3d.y;
        double d3 = this.z - vector3d.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public double distanceSquared(Vector3d vector3d) {
        double d = this.x - vector3d.x;
        double d2 = this.y - vector3d.y;
        double d3 = this.z - vector3d.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public double dot(Vector3d vector3d) {
        return this.x * vector3d.x + this.y * vector3d.y + this.z * vector3d.z;
    }

    public void normalize() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        double d2 = d - 1.0;
        if (d2 > 4.440892098500626E-16 || d2 < -4.440892098500626E-16) {
            double d3 = Math.sqrt(d);
            this.x /= d3;
            this.y /= d3;
            this.z /= d3;
        }
    }

    public void setZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void cross(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d.y * vector3d2.z - vector3d.z * vector3d2.y;
        double d2 = vector3d.z * vector3d2.x - vector3d.x * vector3d2.z;
        double d3 = vector3d.x * vector3d2.y - vector3d.y * vector3d2.x;
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    protected void setRandom(double d, double d2, Random random) {
        double d3 = d2 - d;
        this.x = random.nextDouble() * d3 + d;
        this.y = random.nextDouble() * d3 + d;
        this.z = random.nextDouble() * d3 + d;
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }
}

