/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

public class VMath {
    public static float bias(float value, float b) {
        return b > 0.0f ? (float)Math.pow(value, Math.log(b) / Math.log(0.5)) : 0.0f;
    }

    public static float gain(float value, float g) {
        return 0.5f * ((double)value < 0.5 ? VMath.bias(2.0f * value, 1.0f - g) : 2.0f - VMath.bias(2.0f - 2.0f * value, 1.0f - g));
    }

    public static float bilerp(float a, float b, float c, float d, float u, float v) {
        return a * ((1.0f - u) * (1.0f - v)) + b * (u * (1.0f - v)) + c * (v * (1.0f - u)) + d * (u * v);
    }

    public static float smoothstep(float a, float b, float x) {
        if (x < a) {
            return 0.0f;
        }
        if (x >= b) {
            return 1.0f;
        }
        x = (x - a) / (b - a);
        return x * x * (3.0f - 2.0f * x);
    }

    public static float[] sphericalToCartesian(float rho, float phi, float theta) {
        float x = rho * (float)Math.cos(phi) * (float)Math.cos(theta);
        float y = rho * (float)Math.sin(phi);
        float z = rho * (float)Math.cos(phi) * (float)Math.sin(theta);
        return new float[]{x, y, z};
    }

    public static float[] cartesionToSpherical(float x, float y, float z) {
        float r = (float)Math.sqrt(x * x + y * y + z * z);
        float phi = (float)Math.acos(z / r);
        float theta = (float)Math.atan2(y, x);
        return new float[]{r, phi, theta};
    }
}

