  //--------------------------------
  // Cubic Lighting
  //--------------------------------
  // By Evolved
  // http://www.vector3r.com/
  //--------------------------------

  //-----------------
  // un-tweaks
  //-----------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;    
   matrix ViewInv:ViewInverse; 

  //-----------------
  // tweaks
  //-----------------
   float4 LightPosition = {150.0f, 150.0f, 0.0f, 1.0f};    
   float4 LightColor = {1.0f, 1.0f, 1.0f, 1.0f};    
   float LightRange = 250.0f;    
   float3x3 LightAngle;   
   float4 Ambient = {0.0f, 0.0f, 0.0f, 1.0f};     
   float U=1.0f; 
   float V=1.0f; 
	
  //-----------------
  // Textures
  //-----------------
   texture BaseTX 
    <
	string Name="";
    >;	
   sampler2D Base = sampler_state 
    {
 	texture = <BaseTX>;
    };
   texture NormalTX
    <
	string Name="";
    >;	
   sampler2D Normal = sampler_state 
    {
 	texture = <NormalTX>;
    };
   texture NormalizerTX
    <
	string Name = "";
    >;
   samplerCUBE Normalizer  = sampler_state 
    {
	Texture = <NormalizerTX>;
 	ADDRESSU =  Clamp;
	ADDRESSV =  Clamp;
    };
   texture CubeLightTX 
    <
	string Name = "";
    >;
   sampler CubeLight = sampler_state
    {
	Texture = <CubeLightTX>;
    };

  //-----------------
  // structs 
  //-----------------
   struct input
     {
 	float4 Pos:POSITION; 
 	float2 UV:TEXCOORD; 
	float3 Normal:NORMAL;
 	float3 Tangent:TANGENT;
 	float3 Binormal:BINORMAL;
     };
   struct output
     {
	float4 OPos:POSITION; 
 	float2 Tex:TEXCOORD0; 
  	float3 LightVec:TEXCOORD1; 
	float3 Attenuation:TEXCOORD2;
	float3 ViewVec:TEXCOORD3; 
   	float3 CubeLight:TEXCOORD4; 
     };

  //-----------------
  // vertex shader
  //-----------------
   output VS(input IN) 
     {
 	output OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
 	OUT.Tex=IN.UV*float2(U,V);
	float3 WNor=mul(IN.Normal,World); WNor=normalize(WNor);
	float3 Wtan=mul(IN.Tangent,World); Wtan=normalize(Wtan);
	float3 Wbin=mul(IN.Binormal,World); Wbin=normalize(Wbin);
	float3 WPos=mul(IN.Pos,World);  
	float3x3 TBN={-Wtan,Wbin,WNor}; TBN=transpose(TBN);
	float3 LightPos=LightPosition-WPos; 
	float3 ViewPos=ViewInv[3].xyz-WPos;
	OUT.LightVec=mul(LightPos,TBN);
	OUT.Attenuation=-LightPos/LightRange; 
 	OUT.ViewVec=mul(ViewPos,TBN); 
	OUT.CubeLight=mul(LightAngle,-LightPos);
	return OUT;
     }

  //-----------------
  // pixel shader
  //-----------------
   float4 PS(output IN)  : COLOR
     {
	float4 Texture=tex2D(Base,IN.Tex); 
	float3 NormalMap=tex2D(Normal,IN.Tex)*2-1; 
	float3 LightV=texCUBE(Normalizer,IN.LightVec)*2-1;  	
	float3 View=texCUBE(Normalizer,IN.ViewVec)*2-1;
	float Normal=saturate(dot(NormalMap,LightV)); 
	float Specular=saturate(dot(reflect(-View,NormalMap),LightV));
	Specular=Specular*Specular; Specular=Specular*Specular;
	Specular=Specular*Specular;
	float4 DiffuseLight=1-saturate(dot(IN.Attenuation,IN.Attenuation));
	float4 Light=DiffuseLight*LightColor*texCUBE(CubeLight,IN.CubeLight);
	return Texture*(((Normal+Specular)*Light)+Ambient);
     }

  //-----------------
  // techniques   
  //-----------------
   technique CubicLighting
      {
 	pass p1
      {		
 	vertexShader = compile vs_1_1 VS(); 
 	pixelShader  = compile ps_1_4 PS(); 	
      }
      }
