
float4x4 worldViewProjection;

struct IN_Vertex {
    float4 pos		: POSITION;
    float3 norm 	: NORMAL; 
};

struct IN_Pixel {
    float4 pos : POSITION;
    float3 norm : TEXCOORD0;
    float3 opos : TEXCOORD1;
};

struct PS_In {
    float4 pos : TEXCOORD1;
    float3 norm : TEXCOORD0;
};

struct PS_Out {
	float4 pixel	: COLOR0;
};

IN_Pixel VS_SolidObject ( IN_Vertex IN ) {
	IN_Pixel OUT;
	OUT.pos.xyzw = 0.f;
	OUT.pos = mul( IN.pos, worldViewProjection );
	OUT.norm = normalize( mul( IN.norm, worldViewProjection ) );
	OUT.opos = OUT.pos.xyz;
	return OUT;
}

PS_Out PS_SolidObject ( PS_In IN ) 
{
	PS_Out OUT;
	float3 pos = IN.pos.xyz;
	float3 norm = IN.norm.xyz;
	float3 lightVec = normalize(-pos);
	float d = dot( lightVec, IN.norm );
	OUT.pixel = float4(d,d,d,1);
	return OUT;
}


technique SolidObject
{
    pass p0
    {
		AlphaBlendEnable = False;
		VertexShader = compile vs_2_0 VS_SolidObject ();
		PixelShader = compile ps_2_0 PS_SolidObject ();
    }
}

