 #! /usr/bin/perl -w
 
## SUBROUTINES to monkey.pl 
 

# Perl OpenGL Demo 
# Author: Maria - Ganglion
# Date:  7.Mai 2009 - 18.Juli 2009

## Demo for solskogen 2009
## Group: Delirium Tremors
## Demoname: The broken monkey
## working group members: just me ... (Haha Daren!)


package monkeySubs;		# Name des Moduls
use Exporter;			# Einbinden des Exporter-Moduls für das Interface unseres Moduls
@ISA = ('Exporter');		# Verwendung der import-Methode aus dem Exporter-Modul
#@EXPORT = qw (sonne,boot,palme,affe,affeStueckl,kokosnuss);	# Exportieren der Hauptroutine und des Rückgabewerts der Hauptroutine => von außerhalb des Moduls aufrufbar
@EXPORT = qw (sonne);
@EXPORT = qw (boot);
@EXPORT = qw (palme);
@EXPORT = qw (affe);
@EXPORT = qw (affeStueckl);
@EXPORT = qw (kokosnuss);

use strict;			# Aktivieren des Strict-Paradigmas: alle Variablen müssen deklariert werden


use OpenGL qw(:all);    # Use the OpenGL module
use strict;             # Use strict typechecking
use OpenGL::Image;		# um texturen einzubinden
use Image::Magick;		
use MPEG::MP3Play qw(:msg :state :mask);		# Um mp3s abzuspielen	/usr/local/lib/perl/5.8.8/MPEG



sub sonne(){
	my $time = shift;
	my $q = 0;
	
	        #wirrender Kreis.
            glLoadIdentity();
            glTranslated(5, 4.0, -10.0);  		
            
            glBegin(GL_TRIANGLES);		  #= circel
               my $k;
               my $s;
                if ($q<1){
                     $s = 0;
                     $k = 60; 
                     $q = 1;
                    }
                else{
                    $s = 1;
                    $k = 60;
                    $q = 0;
                }
                for (my $i=$s; $i<$k; $i++)
                {
                    my $winkel = (6.28 * $i) / $k;
                    my $winkel2 = (6.28 * ($i+1)) / $k;
                    my $x = sin($winkel);
                    my $y = cos($winkel)-1;
                    my $x2 = sin($winkel2);
                    my $y2 = cos($winkel2)-1;
                    glColor3d(0.9, 0.7, 0.1);    # orange
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                    $i++;
                }
            glEnd();  
         
        
        
        # aufbauender Kreis:
            glBegin(GL_TRIANGLES);  #= circel
			my $kant;
            if ($time > 80) {
            	my $odd = $time%2;			# % = modulo Rest
            	$kant = 160+$odd*17;
             }
            else { $kant = $time*2}

                for (my $i=0; $i<$kant; $i++)
                {
                    my $winkel = (6.28 * $i) / $kant;
                    my $winkel2 = (6.28 * ($i+1)) / $kant;
                    my $x = sin($winkel);
                    my $y = cos($winkel)-1;
                    my $x2 = sin($winkel2);
                    my $y2 = cos($winkel2)-1;
                    glColor3d(0.9, 0.6, 0.0);    # Set the current drawing color
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                    $i++;
                }
            glEnd();
 
    	glLoadIdentity();				# Zurück transformiert
}			# ENDE sub sonne

##########################

sub boot(){
         
          glBegin(GL_POLYGON);
            # undersida:
            glColor3d(0.3, 0.2, 0);
            glVertex3d(-1,-1,0);
            glVertex3d(1,-1,0);
            glVertex3d(1,-1,-1);
            glVertex3d(-1,-1,-1);
         glEnd();   
         
         
         glBegin(GL_POLYGON);
            # baksida:
            glColor3d(0.31, 0.15, 0);
            glVertex3d(-1.5,0,-1);
            glVertex3d(1.5,0,-1);
            glVertex3d(1,-1,-1);
            glVertex3d(-1,-1,-1);
         glEnd();   
         
             glBegin(GL_POLYGON);
            # hoyre kortesida:
            glColor3d(0.2, 0.1, 0);
            glVertex3d(1.5,0,0);
            glVertex3d(1.5,0,-1);
            glVertex3d(1,-1,-1);
            glVertex3d(1,-1,0);
         glEnd();   
         
        glBegin(GL_POLYGON);
            # venstre kortesida:
            glColor3d(0.2, 0.1, 0);
            glVertex3d(-1.5,0,0);
            glVertex3d(-1.5,0,-1);
            glVertex3d(-1,-1,-1);
            glVertex3d(-1,-1,0);
         glEnd();   
         
        glBegin(GL_POLYGON);
		    # framsida:
            glColor3d(0.35, 0.15, 0.0);
            glVertex3d(-1.5,0,0);
            glVertex3d(1.5,0,0);
            glVertex3d(1,-1,0);
            glVertex3d(-1,-1,0);
         glEnd(); 
        
         
        glBegin(GL_LINE);
            # Mast:
            glColor3d(0, 0, 0);
            glVertex3d(0,0,-0.5);
            glVertex3d(0,2,-0.5);
         glEnd();
         
         
        glBegin(GL_TRIANGLES);
            # seil:
            glColor3d(0.8, 0.8, 1);
            glVertex3d(0,0.3,-0.5);
            glVertex3d(0,2,-0.5);
            glVertex3d(-2,1.5, 0.2);
         glEnd();   

}

##############################

sub palme(){

	my $x = shift;
	my $y = shift; 
	
	glTranslated($x,$y,0);					# position dieser Palme
            
     for(my $i=0; $i<2.8; $i=$i+0.4){		# Stamm
         glBegin(GL_POLYGON);
            glColor3d(0.2,0.1,0);			# braun
            glVertex3d(0.05,$i,0);
            glVertex3d(0.35,$i,0);
            glVertex3d(0.4,($i+0.4),0);
            glVertex3d(0,($i+0.4),0);
		glEnd();	
	}
	for (my $i=0; $i<0.1; $i=$i+0.01){		# Blatt 1 links
		glBegin(GL_LINE);
			glColor3d(0.2, 0.9, 0.1);		# grün
			glVertex3d($i,2.8,0);
			glVertex3d($i-0.1,3.1,0);
			
			glVertex3d($i-0.1,3.1,0);
			glVertex3d($i-0.2,3.1,0);
			
			glVertex3d($i-0.2,3.1,0);
			glVertex3d($i-0.34,1.6,0);
		glEnd();
	}
	for (my $i=0.1; $i<0.2; $i=$i+0.01){		# Blatt 2 links
		glBegin(GL_LINE);
			glColor3d(0.2, 0.9, 0.1);
			glVertex3d($i,2.8,0);
			glVertex3d($i-0.1,3.2,0);
			
			glVertex3d($i-0.1,3.2,0);
			glVertex3d($i-0.15,3.2,0);
			
			glVertex3d($i-0.15,3.2,0);
			glVertex3d($i-0.2,1.5,0);
		glEnd();
	}
	for (my $i=0.15; $i<0.25; $i=$i+0.01){		# Blatt Mitte
		glBegin(GL_LINE);
			glColor3d(0.2, 0.9, 0.1);
			glVertex3d($i,2.8,0);
			glVertex3d($i,3.2,0);
			
			glVertex3d($i,3.2,0);
			glVertex3d($i-0.01,1.4,0);
		glEnd();
	}
	for (my $i=0.2; $i<0.3; $i=$i+0.01){			# Blatt 1 rechts
		glBegin(GL_LINE);	
			glColor3d(0.2, 0.9, 0.1);
			glVertex3d($i,2.8,0);
			glVertex3d($i+0.1,3.21,0);
			
			glVertex3d($i+0.1,3.21,0);
			glVertex3d($i+0.15,3.21,0);
			
			glVertex3d($i+0.15,3.21,0);
			glVertex3d($i+0.25,1.53,0);
		glEnd();
	}
	for (my $i=0.25; $i<0.35; $i=$i+0.01){			# Blatt 2 rechts
		glBegin(GL_LINE);	
			glColor3d(0.2, 0.9, 0.1);
			glVertex3d($i,2.8,0);
			glVertex3d($i+0.1,3,0);
			
			glVertex3d($i+0.1,3,0);
			glVertex3d($i+0.24,3,0);
			
			glVertex3d($i+0.24,3,0);
			glVertex3d($i+0.4,1.6,0);
		glEnd();
	}
}			# END sub Palme

###########################

sub kokosnuss(){
	my $a = shift;
	my $b = shift;
	glPushMatrix();
	glTranslated($a,$b,0);

	  glBegin(GL_TRIANGLES);  		
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/7;
                    my $y = cos($winkel)/5;
                    my $x2 = sin($winkel2)/7;
                    my $y2 = cos($winkel2)/5;
                    glColor3d(0.2, 0.1, 0);    		# dunkelbraun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
	glPopMatrix();	
}  			# END sub Kokosnuss


###########################


sub affe(){
	glPushMatrix();
	glTranslated(-5,0.2,0);
	glPushMatrix();							# Affenposition wird gespeichert
	
		glTranslated(-0.30,0.05,0);	
	  glBegin(GL_TRIANGLES);  		# Ohr links
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/6;
                    my $y = cos($winkel)/6;
                    my $x2 = sin($winkel2)/6;
                    my $y2 = cos($winkel2)/6;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
	glTranslated(0.55,0,0);	
	  glBegin(GL_TRIANGLES);  		# Ohr rechts
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/6;
                    my $y = cos($winkel)/6;
                    my $x2 = sin($winkel2)/6;
                    my $y2 = cos($winkel2)/6;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();

	glPopMatrix();
		glPushMatrix();
     glBegin(GL_TRIANGLES);  		# KOPF
                for (my $i=0; $i<60; $i++)
                {
                    my $winkel = (6.28 * $i) / 60;
                    my $winkel2 = (6.28 * ($i+1)) / 60;
                    my $x = sin($winkel)/3;
                    my $y = cos($winkel)/3;
                    my $x2 = sin($winkel2)/3;
                    my $y2 = cos($winkel2)/3;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
	glTranslated(-0.13,0.1,0);					
     glBegin(GL_TRIANGLES);  		# Auge Links
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/35;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/35;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.1, 0.1, 0.1);    	
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
     glTranslated(0.26,0,0);					
   	  glBegin(GL_TRIANGLES);  		# Auge rechts
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/35;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/35;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.1, 0.1, 0.1);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
		glTranslated(-0.13,-0.22,0);					
    	 glBegin(GL_TRIANGLES);  		# Mund
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/15;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/15;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.2, 0.1, 0.1);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();

      glPopMatrix();
      	glPushMatrix();
      glTranslated(0.6,-1.1,0);
       glRotated(215,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Schwanz 1
                for (my $i=0; $i<60; $i++)
                {
                    my $winkel = (6.28 * $i) / 60;
                    my $winkel2 = (6.28 * ($i+1)) / 60;
                    my $x = sin($winkel)/2;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/2;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.6, 0.4, 0.0);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
           glTranslated(-0.49,0.09,0);
           glRotated(115,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Schwanz 2
                for (my $i=0; $i<60; $i++)
                {
                    my $winkel = (6.28 * $i) / 60;
                    my $winkel2 = (6.28 * ($i+1)) / 60;
                    my $x = sin($winkel)/8;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/8;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.6, 0.4, 0.0);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();

     glPopMatrix();
     	glPushMatrix();
		glTranslated(0,-1.0,0);
    	 glBegin(GL_TRIANGLES);  		# Körper
                for (my $i=0; $i<60; $i++)
                {
                    my $winkel = (6.28 * $i) / 60;
                    my $winkel2 = (6.28 * ($i+1)) / 60;
                    my $x = sin($winkel)/2.4;
                    my $y = cos($winkel)/1.4;
                    my $x2 = sin($winkel2)/2.4;
                    my $y2 = cos($winkel2)/1.4;
                    glColor3d(0.2, 0.2, 0.0);    	# braun2
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd(); 	
     glPopMatrix();		
     	glPushMatrix();	       
      glTranslated(-0.6,-0.8,0);
        glRotated(130,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Arm links
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/6.5;
                    my $y = cos($winkel)/2;
                    my $x2 = sin($winkel2)/6.5;
                    my $y2 = cos($winkel2)/2;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
     glPopMatrix();
     	glPushMatrix();
       glTranslated(0.45,-0.85,0);
           glRotated(35,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Arm rechts
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/6.5;
                    my $y = cos($winkel)/2;
                    my $x2 = sin($winkel2)/6.5;
                    my $y2 = cos($winkel2)/2;
                    glColor3d(0.6, 0.4, 0.0);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
      glPopMatrix();
      	glPushMatrix();
     glTranslated(-0.25,-1.8,0);
           glRotated(165,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Fuß links
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/8;
                    my $y = cos($winkel)/3;
                    my $x2 = sin($winkel2)/8;
                    my $y2 = cos($winkel2)/3;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();

       glPopMatrix();
       	glPushMatrix();
       glTranslated(0.15,-1.8,0);
           glRotated(175,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Fuß rechts
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/8;
                    my $y = cos($winkel)/3;
                    my $x2 = sin($winkel2)/8;
                    my $y2 = cos($winkel2)/3;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
	glPopMatrix();
	glPopMatrix();
 }		# sub Affe Ende
 
 ###############################
 
 

sub affeStueckl(){
	glPushMatrix();
	glTranslated(-5,0.2,0);
	glTranslated(-0.3,-1.6,0);	
	glRotated(20,0,0,100);
	  glBegin(GL_TRIANGLES);  		# Ohr links
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/6;
                    my $y = cos($winkel)/6;
                    my $x2 = sin($winkel2)/6;
                    my $y2 = cos($winkel2)/6;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
	glTranslated(0.55,-0.1,0);	
	  glBegin(GL_TRIANGLES);  		# Ohr rechts
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/6;
                    my $y = cos($winkel)/6;
                    my $x2 = sin($winkel2)/6;
                    my $y2 = cos($winkel2)/6;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();

	glTranslated(-0.45,0,0);	

     glBegin(GL_TRIANGLES);  		# KOPF
                for (my $i=0; $i<60; $i++)
                {
                    my $winkel = (6.28 * $i) / 60;
                    my $winkel2 = (6.28 * ($i+1)) / 60;
                    my $x = sin($winkel)/3;
                    my $y = cos($winkel)/3;
                    my $x2 = sin($winkel2)/3;
                    my $y2 = cos($winkel2)/3;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
	glTranslated(-0.13,0.12,0);					
     glBegin(GL_TRIANGLES);  		# Auge Links
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/35;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/35;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.1, 0.1, 0.1);    	
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
     glTranslated(0.26,0,0);					
   	  glBegin(GL_TRIANGLES);  		# Auge rechts
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/35;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/35;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.1, 0.1, 0.1);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
		glTranslated(-0.13,-0.22,0);					
    	 glBegin(GL_TRIANGLES);  		# Mund
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/15;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/15;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.2, 0.1, 0.1);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();

      glTranslated(0.6,-0.2,0);
       glRotated(215,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Schwanz 1
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/2;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/2;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.6, 0.4, 0.0);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
           glTranslated(-0.49,0.09,0);
           glRotated(115,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Schwanz 2
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/8;
                    my $y = cos($winkel)/35;
                    my $x2 = sin($winkel2)/8;
                    my $y2 = cos($winkel2)/35;
                    glColor3d(0.6, 0.4, 0.0);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();

 		glTranslated(-0.3,0,0);
 		glRotated(80,0,0,100);
    	 glBegin(GL_TRIANGLES);  		# Körper
                for (my $i=0; $i<60; $i++)
                {
                    my $winkel = (6.28 * $i) / 60;
                    my $winkel2 = (6.28 * ($i+1)) / 60;
                    my $x = sin($winkel)/2.4;
                    my $y = cos($winkel)/1.4;
                    my $x2 = sin($winkel2)/2.4;
                    my $y2 = cos($winkel2)/1.4;
                    glColor3d(0.2, 0.2, 0.0);    	# braun2
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd(); 	
      glTranslated(0,0,0);
        glRotated(130,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Arm links
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/6;
                    my $y = cos($winkel)/2;
                    my $x2 = sin($winkel2)/6;
                    my $y2 = cos($winkel2)/2;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
       glTranslated(0.45,0,0);
           glRotated(35,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Arm rechts
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/6;
                    my $y = cos($winkel)/2;
                    my $x2 = sin($winkel2)/6;
                    my $y2 = cos($winkel2)/2;
                    glColor3d(0.6, 0.4, 0.0);    	# braun
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
     glTranslated(-0.15,0.2,0);
           glRotated(165,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Fuß links
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/8;
                    my $y = cos($winkel)/3;
                    my $x2 = sin($winkel2)/8;
                    my $y2 = cos($winkel2)/3;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();

       glTranslated(0.15,0,0);
           glRotated(175,0,0,100);	
		  glBegin(GL_TRIANGLES);  			# Fuß rechts
                for (my $i=0; $i<40; $i++)
                {
                    my $winkel = (6.28 * $i) / 40;
                    my $winkel2 = (6.28 * ($i+1)) / 40;
                    my $x = sin($winkel)/8;
                    my $y = cos($winkel)/3;
                    my $x2 = sin($winkel2)/8;
                    my $y2 = cos($winkel2)/3;
                    glColor3d(0.6, 0.4, 0.0);    	# braun1
                    glVertex3d($x, $y, 0.0);
                    glVertex3d($x2, $y2, 0.0);
                    glVertex3d(0.0, 0.0, 0.0);
                }
            glEnd();
    glPopMatrix();
   
 }		# sub Affe-stueckl Ende

 


1;
