#!/usr/bin/perl -w
#########################################################################
#
# Simple PERL Xaudio Player
#
# This sample code shows how to control 'rxaudio' from a perl script
#
# See the rxaudio documentation for a list of messages that can be
# sent and received.
#
#########################################################################

#########################################################################
# library modules
#########################################################################
use FileHandle;
use IPC::Open2;

#########################################################################
# package
#########################################################################
package XaudioPlayer;
my($reader, $writer);

#########################################################################
# new
#########################################################################
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;

    $self->{READER} = new FileHandle;
    $self->{WRITER} = new FileHandle;

    IPC::Open2::open2($self->{READER}, $self->{WRITER}, "rxaudio");

    return $self;
}

#########################################################################
# Open
#########################################################################
sub Open
{
    my($self) = shift;
    my($name) = shift;
    $self->{WRITER}->print("open $name\n");
}

#########################################################################
# Play
#########################################################################
sub Play
{
    my($self) = shift;
    $self->{WRITER}->print("play\n");
}

#########################################################################
# Exit
#########################################################################
sub Exit
{
    my($self) = shift;
    $self->{WRITER}->print("exit\n");
}

#########################################################################
# GetMessage
#########################################################################
sub GetMessage
{
    my($self) = shift;
    return $self->{READER}->getline;
}


package main;
#########################################################################
# message handler
#########################################################################
sub handle_message
{
    local($message) = $_[0];

    # this is a sample code, so print the message for debug
    print $message;

    # ask the decoder to exit when the end of file is reached
    # (this is just as an example. normally you would go to the
    #  next file to play)
    $player->Exit if $message =~ /EOF/;

    # if the decoder process exits, exit the main process
    exit(0) if $message eq "MSG notify exited";

    # TODO: handle the other messages that you wish to act upon
}

#########################################################################
# main
#########################################################################
$player = new XaudioPlayer;
$player->Open("/classic/bits/mp3/reed.mp3");
$player->Play;
while($message = $player->GetMessage) {
    &handle_message($message);
}


