//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
sampler2D input : register(s0);
float4 main(float2 uv : TEXCOORD, float4 diffuse : COLOR) : COLOR 
{ 
		
		float scale = 1.0f;
		float off = 1.00f;
		
		float SSCALE = 0.025f;
		float SSCALE2 = SSCALE *0.5;
		
		float2 ouv = uv.xy;
	
    float4 OrigColor;
    float4 Color = tex2D (input, uv.xy);
    OrigColor = Color;
    
    float2 off2d;
    
    for (int y=-1; y<1; y++)
    	for (int x=-2; x<2; x++)
    	{
    		uv.x = ouv.x + x*0.005; 
    		uv.y = ouv.y + y*0.0036 + cos(diffuse.b+diffuse.a+y+uv.x)*0.02f;
    		float a = uv.x+uv.y;
    		off2d.x = sin(diffuse.r + a) * SSCALE;
    		off2d.y = cos(diffuse.a + a) * SSCALE;
    		Color += tex2D(input, uv.xy + off2d);
    	}
  	Color = Color / 4;
  	
   
    // float total = (OrigColor-r + OrigColor.g + OrigColor.b)/3;
    Color = 0.5 + Color * ouv.y;

    OrigColor = lerp(Color * diffuse, OrigColor, 0.4);
    
    /*
    off *= sin(diffuse.r + diffuse.g + OrigColor.b);
    
    float4 c1 = tex2D (input, uv.xy * off);
    
    off *= cos(diffuse.b + diffuse.a + OrigColor.r);
    float4 c2 = tex2D (input, uv.xy * off);
    
    float p = (ouv.y + 0. + sin(c1.r+c2.g+c2.a));
    
		float4 noiseColor = c1*c2*p;

    OrigColor = OrigColor * diffuse;
    OrigColor = OrigColor + (noiseColor*0.15);
    */
    
    return OrigColor;
}


//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique Basic
{
    pass P0
    {          
        VertexShader = null;
        PixelShader  = compile ps_3_0 main();
    }
}

