#include "utils.fx"

float4x4 	g_worldViewProjection;
float			g_noiseOffsetX;
float			g_noiseOffsetY;
float			g_skyUFix;
float			g_brightness;
float			g_contrast;

texture		g_inputSkyTexture;
texture		g_inputNoiseTexture;
texture		g_inputCloudsTexture;

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
sampler2D inputTex0 : register(s0);
sampler2D inputTex1 : register(s1);

sampler SkySampler = sampler_state
{
	Texture = <g_inputSkyTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};

	
sampler NoiseSampler = sampler_state
{
	Texture = <g_inputNoiseTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};

sampler CloudsSampler = sampler_state
{
	Texture = <g_inputCloudsTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};

//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV0  : TEXCOORD0;  // vertex texture coords 
    float4 TextureUV1  : TEXCOORD1;  // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT SkyVS( float4 vPos : POSITION, 
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0,
                         float2 vTexCoord1 : TEXCOORD1)
{
    VS_OUTPUT Output;

		vTexCoord0.y = (g_skyUFix+vTexCoord0.y);
		
		vTexCoord0.x += 0.75;
		
		Output.TextureUV1.x = vTexCoord0.x*1;
		Output.TextureUV1.y = vTexCoord0.y;
		Output.TextureUV1.z = 0;
		Output.TextureUV1.w = 0;

		float v = (1-abs(vPos.y));
		v = pow(v, 3.5)*1.0;
		
		if (vPos.y<0)
		{
			// 16.9.2009 3:18:23vPos.y *= 0.25;
			Output.Position = mul(vPos, g_worldViewProjection);

			// vTexCoord0.y = 4.25;
			Output.TextureUV1.y = 0.5 - Output.TextureUV1.y*0.5;
			Output.TextureUV1.w = 1;
			// vTexCoord0.y *= 2.2;

		 		// 16.9.2009 3:03:2516.9.2009 3:03:2716.9.2009 3:03:28VTexCoord0.y = -0.5 -vTexCoord0.y;

			Output.Diffuse = 1; //lerp(float4(v,v,v,1), float4(130.0/255, 125/255, 70/255, 1), 1-v); //1.0 * (1-abs(vPos.y));
			
		 		
		}
		else
		{
			Output.Position = mul(vPos, g_worldViewProjection);
			
			// Output.Diffuse = vColor; // * (1-vPos.y);
			
			Output.Diffuse = 1; // lerp(float4(v,v,v,1), float4(1, 0, 0, 0), 1-v); //1.0 * (1-abs(vPos.y));
			
		}
		
		Output.Diffuse.w = v;


		
		// VTexCoord0.x = 0.5 + -0.5*vPos.x; // cos(vPos.x) + sin(vPos.y);
		// vTexCoord0.y = 0.5 + -0.5*vPos.y; // sin(vPos.x) - cos(vPos.y);
		
		// vTexCoord0.x = 0 // 2.05;
		
		/*
		vTexCoord0.x = vPos.x;
		vTexCoord0.y = -vPos.y + 0.5;
		vTexCoord0.y  = clamp(vTexCoord0.y, 0, 1);
		*/
		
		
		Output.TextureUV0 = vTexCoord0;
    
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};


float4 SkyWithCloudsPS( float2 uv0 : TEXCOORD0, float4 uv1 : TEXCOORD1, float4 color : COLOR0) : COLOR0
{ 
		float4 skyCol = tex2D(SkySampler, uv0);
		
		float ns = g_noiseOffsetY * 0.05f;
		
		// float4 skyNoise =tex2D(NoiseSampler, float2(uv1.x, uv1.y)*0.15);
		
		
		float4 uvN;
		uvN.x = uv1.x + ns*0.0014; // + ((skyNoise.x*0.25) + skyCol.x)*0.054;
		uvN.y = uv1.y + ns; //  + (skyNoise.y + ns)*0.144;
		uvN.z = 0;
		uvN.w = getGrayScale(skyCol); // +skyNoise);
		float4 nCol = 1-tex2Dlod(CloudsSampler, uvN*(5 + sin(ns)));
		// float4 skyNoise = tex2Dlod(NoiseSampler, nCol*0.0 + uvN);
		// skyNoise -= 0.5;	
		// nCol *= (1+(tex2Dlod(CloudsSampler, skyNoise)-0.5));
		// nCol *= 1+tex2Dlod(NoiseSampler, skyNoise);
				
		// nCol *= skyNoise;
		
		float nc = (1-getGrayScale(nCol)); //  - 0.5;
		// nc *= 0.5;
		// nc += 0.5;
		

		// nCol = lerp(nCol, 1-getGrayScale(nCol), uv1.w); // (( -0.5;
		
		float4 col = skyCol - nc*0.2;
				
    // return lerp(col, color, color.w); // ocolor;
    col = col * color;
    
		col -= 0.5;
		col *= g_contrast;
		col += 0.5 + g_brightness;
		col.w = 1;
		
		return col;    
}


technique SkyWithClouds
{
    pass P0
    {   
        VertexShader = compile vs_3_0 SkyVS( );
        PixelShader  = compile ps_3_0 SkyWithCloudsPS( ); 
    }
}


