## out.vert

uniform sampler2D tex;
uniform float foo;
uniform float foo2;

const vec3 lightPos = vec3( 100.0, 100.0, 100.0 );
const float px = 1.0 / 256.0 * ( 2.0 * foo - 1.0 );
const vec2 dxy = ( px, px );

varying float luminance;
varying float texInt;

void main()
	{
	vec4 v = gl_Vertex;
	
	float z = texture2D( tex, gl_MultiTexCoord0.st ).r - foo * ( 1.0 + sin( foo2 ) * 0.1 );
	if ( z >= 0.0 )
		{
		v.y += sin( z * 3 ) * 20.0;
		}

	gl_Position = gl_ModelViewProjectionMatrix * v;
	gl_TexCoord[0].st = gl_MultiTexCoord0.st;
	luminance = texture2D( tex, max( gl_MultiTexCoord0.st - dxy, 0.0 ) ).r * 2.0;
	luminance -= texture2D( tex, gl_MultiTexCoord0.st ).r;
	luminance -= texture2D( tex, min( gl_MultiTexCoord0.st + dxy, 1.0 ) ).r;
	luminance = clamp( luminance, 0.0, 1.0 );
	texInt = clamp( v.y, 0.0, 5.0 );
	}

## out.frag

uniform sampler2D noise;
varying float luminance;
varying float texInt;

void main()
	{
	vec4 t = texture2D( noise, gl_TexCoord[0].st ) + vec4( 0.1 );
	float r = luminance;
	float g = r * r * 0.8;
	float b = g * g * 0.8;
	vec4 col = min( t * vec4( r, g, b, 1.0 ) * texInt, 1.0 );
	gl_FragColor = col;	
	}