## dispmap.vert

uniform sampler2D tex;
varying float intensity;

vec2 SphereMap( in vec3 ecPos3, in vec3 normal )
	{
	float m;
	vec3 r, u;
	u = normalize( ecPos3 );
	r = reflect( u, normal );
	m = 2.0 * sqrt( r.x * r.x + r.y * r.y + ( r.z + 1.0 ) * ( r.z + 1.0 ) );
	return vec2( r.x / m + 0.5, r.y / m + 0.5 );
	}

void main()
	{
	float d = pow( texture2D( tex, gl_MultiTexCoord0.st ).r, 3.0 ) * 80.0 + 2.0;
	vec4 v = gl_Vertex - gl_Color * d;
	
	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_Position = gl_ModelViewProjectionMatrix * v;
	
	vec3 lightPos = gl_LightSource[0].position.xyz;
	vec3 ecPos = vec3( gl_ModelViewMatrix * gl_Vertex );
	vec3 tnorm = normalize( gl_NormalMatrix * gl_Normal );
	vec3 lightVec = normalize( lightPos - ecPos );
	vec3 reflectVec = reflect( -lightVec, tnorm );
	vec3 viewVec = normalize( -ecPos );
	
	float diffuse = max( dot( lightVec, tnorm ), 0.0 );
	float spec = 0.0;
	if ( diffuse > 0.0 )
		{
		spec = max( dot( reflectVec, viewVec ), 0.0 );
		spec = pow( spec, 16.0 );
		}
		
	intensity = min( ( 0.5 * diffuse + 0.5 * spec ), 1.0 ) + 0.5;
	
	gl_TexCoord[1] = vec4( SphereMap( ecPos, tnorm ), 0, 0 );
	}

## dispmap.frag

uniform sampler2D tex;
varying float intensity;

void main()
	{
	gl_FragColor = texture2D( tex, gl_TexCoord[0] ) * texture2D( tex, gl_TexCoord[1] );
	gl_FragColor *= intensity;
	gl_FragColor.a = 1.0;
	}