## out.vert

void main()
	{
	gl_Position = ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_FrontColor = gl_Color;
	}

## out.frag

uniform sampler2D tex;

const float step_w = 1.0 / 1280.0;
const float step_h = 1.0 / 720.0;

const vec2 offset[9] = {
	vec2( -step_w, -step_h ), vec2( 0, -step_h ), vec2( step_w, -step_h ),
	vec2( -step_w, 0 ), vec2( 0, 0 ), vec2( step_w, 0 ),
	vec2( -step_w, step_h ), vec2( 0, step_h ), vec2( step_w, step_h )
};
const float kernel[9] = {
	-1.0, -1.0, -1.0,
	-1.0, 8.0, -1.0,
	-1.0, -1.0, -1.0
};

void main()
	{
	vec4 col;
	for ( int i = 0; i < 9; i++ )
		{
		col += texture2D( tex, gl_TexCoord[0].st + offset[i] ) * kernel[i];
		}
	col = texture2D( tex, gl_TexCoord[0].st ) + col * 0.5;
	col.a = gl_Color.a;
	gl_FragColor = min( col, 1.0 );	
	}