#define _CRT_SECURE_NO_DEPRECATE
#include <math.h>
#include <time.h>
#include <stdio.h>
#include <map>
#include <set>
#include <list>

using std::map;
using std::set;
using std::list;

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned long ulong;

#define OPEN		' '
#define SELF		'X'
#define WALL		'#'
#define MON			'M'
#define COIN		'.'
#define MCOIN		'o'
#define NOTSET	'N'
#define CLOSED	'C'

class dir
{
	static char _dirc[];
	int _d;
public:
	dir()				: _d(4)		{ ; }
	dir(int d)			: _d(d)		{ ; }
	dir(const dir& a)	: _d(a._d)	{ ; }

	int		as_int() const	{ return _d; }
	char	as_char() const { return _dirc[_d]; }

	bool operator==(const dir& a) const	{ return _d == a._d; }
};
const dir NORTH(0);
const dir EAST(1);
const dir SOUTH(2);
const dir WEST(3);
const dir CENTER(4);
char dir::_dirc[] = { 'N', 'E', 'S', 'W', 'C' };

class node;
typedef node* nodep;
class node
{
	nodep _links[4];
	void clear_links() { _links[0] = _links[1] = _links[2] = _links[3] = NULL; }
public:
	const uint x;
	const uint y;

	node(uint nx, uint ny)	: x(nx),  y(ny)  { clear_links(); }
	node(const node& n)		: x(n.x), y(n.y) { clear_links(); }

	void set_link(dir d, nodep l)
	{
		const int di = d.as_int(); 
		if (di < 4) 
			_links[di] = l; 
	}
	
	nodep link(dir d)	
	{
		const int di = d.as_int(); 
		if (di >= 0 && di < 4) 
			return _links[di]; 
		else 
			return NULL;
	}
	nodep link(int i)
	{
		if (i >= 0 && i < 4)
			return _links[i];
		return NULL; 
	}

	bool intersection()
	{
		int c = 0;
		for (int i = 0; i < 4; i++)
			if (_links[i] != NULL) c++;
		return c >= 3;
	}
	nodep onward(nodep from)
	{
		for (int i = 0; i < 4; i++)
			if (_links[i] != NULL && _links[i] != from)
				return _links[i];
		return NULL;
	}
	int	rotation(nodep from, nodep to)
	{
		for (int i = 0; i < 4; i++)
			if (from == _links[i])
				if (to == _links[(i+2)&3])
					return 0;		// ahead
				else if (to == _links[(i+1)&3])
					return -1;		// left
				else if (to == _links[(i+3)&3])
					return 1;		// right
		return 0;

	}
	dir to(nodep n)
	{
		if (n->x > x)	return EAST;
		if (n->x < x)	return WEST;
		if (n->y > y)	return SOUTH;
		if (n->y < y)	return NORTH;
		return CENTER;
	}
};

class grid
{
	const int	_w;
	const int	_h;
	char*		_data;
	char**		_lookup;
	inline void init_lookup()
	{
		_lookup = new char*[_h];
		char* p = _data;
		for (int y = 0; y < _h; y++)
		{
			_lookup[y] = p;
			p += _w;
		}
	}
public:
	grid(int width, int height)	: _w(width), _h(height)	{ _data = new char[_w*_h+4]; init_lookup(); }
	grid(const grid& a) : _w(a._w), _h(a._h)
	{
		int size = _w*_h;
		_data = new char[size+4];
		init_lookup();
		*this = a;

	}
	~grid()	{ delete[] _data; delete[] _lookup; }

	int width()  const { return _w; }
	int height() const { return _h; }

	grid& operator=(const grid& a)
	{
		int size = _w*_h;
		uint* dataend = (uint*)(_data+size);
		uint* datap = (uint*)_data;
		uint* adatap = (uint*)a._data;
		while (datap < dataend)
		{
			*datap = *adatap;
			datap++;
			adatap++;
		}
		return *this;
	}

	char& at(int x, int y)	
	{
		return _lookup[y][x];
	}
	char& at(nodep n)		
	{
		return at(n->x, n->y);
	}
	void clear(char value)
	{
		uint cval = uint(value);
		cval |= cval<<8;
		cval |= cval<<16;
		uint* datae = (uint*)(_data+_w*_h);
		for (uint* datap = (uint*)_data; datap < datae; datap++)
			*datap = cval;
	}
	bool operator==(const grid& a) const
	{
		if (_w != a._w || _h != a._h)
			return false;
		int size = _w*_h;
		uint* dataend = (uint*)(_data+size);
		uint* datap = (uint*)_data;
		uint* adatap = (uint*)a._data;
		while (datap < dataend)
		{
			if (*datap != *adatap)
				return false;
			datap++;
			adatap++;
		}
		return true;
	}
};

namespace astar
{
	template<class T>
	class func0
	{
	public:
		virtual T operator()() const = 0;
	};
	class fzero : public func0<int>
	{
	public:
		virtual int operator()() const { return 0; }
	};
	class fdist : public func0<int>
	{
		nodep _a, _b;
	public:
		fdist(nodep a, nodep b) : _a(a), _b(b) { ; }
		virtual int operator()() const
		{
			int x = abs(int(_a->x - _b->x));
			int y = abs(int(_a->y - _b->y));
//			return int(sqrt(float(x*x + y*y)));
			return int((x+y)*1.5);
		}
	};

	template <class E>
	class aqueue
	{
	public:
		virtual void push(E& e) = 0;
		virtual void update(E& e) = 0;
	};
	template <class E>
	class fifoq : public aqueue<E>
	{
	protected:
		list<E> _data;
	public:
		void clear() { _data.clear(); }
		bool empty() { return _data.empty(); }
		int	 size()	 { return int(_data.size()); }
		E&   top()	 { return _data.front(); }
		void pop()	 { _data.pop_front(); }
		virtual void push(E& e)   { _data.push_back(e); }
		virtual void update(E& e) { ; }
		void remove(E& e) { _data.remove(e); }
	};
	template <class E, class comp=std::less<E> >
	class priq : public fifoq<E>
	{
	public:
		virtual void push(E& e)
		{
			list<E>::iterator it = _data.begin();
			while (it != _data.end() && comp()(*it, e)) it++;
			_data.insert(it, e);
		}
		virtual void update(E& e)
		{
			list<E>::iterator it = _data.begin();
			while (it != _data.end() && *it != e) it++;
			if (it != _data.end())
				_data.erase(it);
			push(e);
		}
	};

	class traceable
	{
	public:
		virtual traceable* prev() = 0;
		virtual nodep pos() = 0;
		virtual grid* map() { return NULL; }
	};

	class score;
	typedef score* scorep;
	class score : public traceable
	{
		int _g, _h;
		scorep _p;
		nodep _n;
		bool _closed;
	public:
		score(scorep p, nodep n, int g, int h) : _p(p), _n(n), _g(g), _h(h), _closed(false) { ; }
		void set_g(int g) { _g = g; }
		void set_h(int h) { _h = h; }
		void set_prev(scorep p) { _p = p; }
		void close()	{ _closed = true; }

		int f() const { return _g+_h; }
		int h()	const { return _h; }
		int g() const { return _g; }
		nodep node() { return _n; }
		nodep pos()  { return node(); }
		scorep prev() { return _p; }
		bool closed() const { return _closed; }
	};
	class scorep_comp { public: bool operator()(const scorep& a, const scorep& b) { return a->f() < b->f(); } };
	class data
	{
	public:
		dir move;
		int dist;
		data(dir m, int d) : move(m), dist(d) { ; }
		data(const data& a) : move(a.move), dist(a.dist) { ; }
	};

	void ensure_lookup_dim(int width, int height);

	data astar(nodep start, nodep goal);
	data nearest(nodep start, grid* map, char type, int maxdist);
	map<char,int> nearest_all(nodep start, grid* map, int maxdist);
	bool caught(nodep self, grid* map, int freedist);

	void print_trace(traceable* end, FILE* out);

	grid* lookupm = NULL;
	void ensure_lookup_dim(int width, int height)
	{
		if (lookupm == NULL)
			lookupm = new grid(width, height);
		else if (lookupm->width() < width || lookupm->height() < height)
		{
			delete lookupm;
			lookupm = new grid(width, height);
		}
	}

	data traceback(scorep s)
	{
		scorep p = s;
		scorep pp = p;
		int c = 0;
		while (p->prev() != NULL)
		{
			pp = p;
			p = p->prev();
			c++;
		}
		return data(p->node()->to(pp->node()), c);
	}
	inline void try_push_score(scorep prev, nodep nod, int newg, const func0<int>& h_func, 
								aqueue<scorep>* open_queue, map<nodep,scorep>* score_map)
	{
		scorep s;
		switch (lookupm->at(nod))
		{
		case NOTSET:
			s = new score(prev, nod, newg, h_func());
			open_queue->push(s);
			(*score_map)[nod] = s;
			lookupm->at(nod) = OPEN;
			break;
		case OPEN:
			s = (*score_map)[nod];
			if (newg < s->g()) // if the score is still open: check if new score is better
			{
				s->set_g(newg);
				s->set_prev(prev);
				open_queue->update(s);
			}
			break;
		}
	}
	data astar(nodep start, nodep goal)
	{
		if (start == goal)
			return data(CENTER, 0);

		priq<scorep,scorep_comp> open_queue;
		lookupm->clear(NOTSET);
		map<nodep,scorep> score_map;
		list<scorep> closed_list;

		scorep topp = new score(NULL, start, 0, fdist(start, goal)());
		open_queue.push(topp);
		lookupm->at(start) = OPEN;
		score_map[start] = topp;
		scorep p, pp;
		nodep n;
		int dirseq[] = { 3, 1, 0, 2 };
		while (!open_queue.empty())
		{
			p = open_queue.top();
			pp = p->prev();
			n = p->node();

			if (n == goal)
				break;
			score_map.erase(n); lookupm->at(n) = CLOSED; closed_list.push_back(p); //score_map[n]->close();
			open_queue.pop();
			int newg = p->g()+1;
			int i = 0;
			for (int i = 0; i < 4; i++)
			{
				nodep link = n->link(dirseq[i]);
				if (link == NULL || (pp != NULL && link == pp->node()) )
					continue;
				try_push_score(p, link, newg, fdist(link, goal), &open_queue, &score_map);
			}
		}
		data result = traceback(p);
				// cleanup
		for (map<nodep,scorep>::iterator it = score_map.begin(); it != score_map.end(); it++)
			delete it->second;
		for (list<scorep>::iterator it = closed_list.begin(); it != closed_list.end(); it++)
			delete *it;

		return result;
	}

	data nearest(nodep start, grid* g, char type, int maxdist)
	{
		if (g->at(start) == type)
			return data(CENTER, 0);

		lookupm->clear(NOTSET);
		fifoq<scorep> open_queue;
		map<nodep,scorep> score_map;
		list<scorep> closed_list;

		scorep topp = new score(NULL, start, 0, 0);
		open_queue.push(topp);
		score_map[start] = topp;
		scorep p, pp;
		nodep n;
		while (!open_queue.empty())
		{
			p = open_queue.top();
			pp = p->prev();
			n = p->node();
			if (p->g() >= maxdist || g->at(n) == type)
				break;
			score_map.erase(n); lookupm->at(n) = CLOSED; closed_list.push_back(p); //score_map[n]->close();
			open_queue.pop();
			int newg = p->g()+1;
			int i = 0;
			for (int i = 0; i < 4; i++)
			{
				nodep link = n->link(i);
				if (link == NULL || (pp != NULL && link == pp->node()) )
					continue;
				try_push_score(p, link, newg, fzero(), &open_queue, &score_map);
			}
		}
		data result = traceback(p);
		if (p->g() >= maxdist)
			result.dist = maxdist;
				// cleanup
		for (map<nodep,scorep>::iterator it = score_map.begin(); it != score_map.end(); it++)
			delete it->second;
		for (list<scorep>::iterator it = closed_list.begin(); it != closed_list.end(); it++)
			delete *it;

		return result;
	}
	map<char,int> nearest(nodep start, grid* g, int maxdist)
	{
		map<char,int> result;

		lookupm->clear(NOTSET);
		fifoq<scorep> open_queue;
		map<nodep,scorep> score_map;
		list<scorep> closed_list;

		scorep topp = new score(NULL, start, 0, 0);
		open_queue.push(topp);
		score_map[start] = topp;
		scorep p, pp;
		nodep n;
		while (!open_queue.empty())
		{
			p = open_queue.top();
			pp = p->prev();
			n = p->node();
			if (!result.count(g->at(n)))
				result[g->at(n)] = p->g();
			if (p->g() >= maxdist)
				break;
			score_map.erase(n); lookupm->at(n) = CLOSED; closed_list.push_back(p); //score_map[n]->close();
			open_queue.pop();
			int newg = p->g()+1;
			int i = 0;
			for (int i = 0; i < 4; i++)
			{
				nodep link = n->link(i);
				if (link == NULL || (pp != NULL && link == pp->node()) )
					continue;
				try_push_score(p, link, newg, fzero(), &open_queue, &score_map);
			}
		}
				// cleanup
		for (map<nodep,scorep>::iterator it = score_map.begin(); it != score_map.end(); it++)
			delete it->second;
		for (list<scorep>::iterator it = closed_list.begin(); it != closed_list.end(); it++)
			delete *it;

		return result;
	}

	class noded
	{
	public:
		node* n;
		int d;
		noded(node* nn, int nd) : n(nn), d(nd) { ; }
		noded(const noded& a) : n(a.n), d(a.d) { ; }
		bool operator<(const noded& a)  const { return d > a.d; }
		bool operator!=(const noded& a) const { return !(n == a.n && d == a.d); }
	};
	bool caught(nodep self, grid* map, int freedist)
	{
		lookupm->clear(NOTSET);
		priq<noded> open;

		open.push(noded(self, 0));
		lookupm->at(self) = OPEN;
	
		while (!open.empty())
		{
			noded nd = open.top();
			open.pop();
			for (int i = 0; i < 4; i++)
			{
				noded newd(nd.n->link(i), nd.d+1);
				if (newd.n == NULL || map->at(newd.n) == MON)
					continue;
				if (lookupm->at(newd.n) != NOTSET)
					continue;
				if (newd.d >= freedist)
					return false;
				open.push(newd);
			}
		}
		return true;
	}

}

class state : public astar::traceable
{
	nodep* _nodee;
	nodep* _nodeb;
	nodep make_node(int x, int y);

	state* _prev;
	list<state*> _nexts;
	int _moves, _turns_left;
	int _w, _h;

	char _eaten;
	bool _eaten_by_mon;
	float _G, _H;

	nodep _firstself;
	nodep _oldself;
	nodep _self;
	list<nodep> _mons;
	grid* _map;
	grid* _beento;
	int _coinc;
	int _mcoinc;
	int _nearest_mon;
	int _turn_bias;
	int _flipc;
	bool _caught;

	void move_mon();
	void find_fg();

	bool is_repeat();
public:
	state();
	state(state* S, dir move, int maxi, clock_t timelimit);
	~state();

	state* prev() { return _prev; }
	nodep pos()  { return self(); }
	grid* map()  { return _map; }
	state* root() { state* p = this; while (p->_prev != NULL) p = p->_prev; return p; }
	float f() const { return _G+_H; }

	int turns_left() const { return _turns_left; }
	int moves() const { return _moves; }
	int mons()  const { return int(_mons.size()); }
	nodep self() { return _self; }
	nodep firstself() { return _firstself; }

	bool operator==(const state& s) const;

	void update_g();

};

inline int max(int a, int b) { return a > b ? a : b; }

nodep state::make_node(int x, int y)
{
	nodep n = new node(x, y);
	const int ym = y-1;
	const int xm = x-1;

	nodep in;
	for (nodep* ip = _nodeb; ip < _nodee; ip++)
	{
		in = *ip;
		if (in->x == x && in->y == ym)
		{
			in->set_link(SOUTH, n);
			n->set_link(NORTH, in);
		}
		if (in->y == y && in->x == xm)
		{
			in->set_link(EAST, n);
			n->set_link(WEST, in);
		}
	}
	*_nodee = n;
	_nodee++;
	return n;
}

state::state()	: _prev(NULL), _G(-200), _H(0), _eaten(OPEN), _eaten_by_mon(false), 
				_moves(0), _mcoinc(0), _coinc(0), _nearest_mon(-1), _turn_bias(0), _flipc(0), _caught(false), _self(NULL)
{
	scanf("%d%d%d\n", &_turns_left, &_w, &_h);
	astar::ensure_lookup_dim(_w, _h);
	_nodeb = _nodee = new nodep[_w*_h];
	_map = new grid(_w, _h);
	_beento = new grid(_w, _h);
	_beento->clear('0');
	for (int y = 0; y < _h; y++)
	{
		for (int x = 0; x < _w; x++)
		{
			char type = getc(stdin);
			_map->at(x,y) = type;
			if (type != WALL)
			{
				nodep n = make_node(x,y);
				switch (type)
				{
				case COIN:	_coinc++;			break;
				case MON:	_mons.push_back(n);	break;
				case SELF:	_firstself = _oldself = _self = n;	break;
				case MCOIN: _mcoinc++;			break;
				}
			}
		}
		getc(stdin);
	}
	if (_self == NULL)
		return;
	find_fg();
	_beento->at(_self)++;
}

state::state(state *S, dir move, int maxi, clock_t timelimit) : _prev(S), _moves(S->_moves), _turns_left(S->_turns_left),
									_w(S->_w), _h(S->_h), _self(S->_self), _firstself(NULL), _G(S->_G), _H(0), _eaten(OPEN), 
									_eaten_by_mon(false), _mcoinc(S->_mcoinc), _coinc(S->_coinc), _turn_bias(S->_turn_bias), 
									_flipc(S->_flipc), _caught(false), _beento(new grid(*(S->_beento))),
									_map(new grid(*(S->_map))),	_nodee(S->_nodee), _nodeb(S->_nodeb)
{
	S->_nexts.push_back(this);
			// legg til monstrene i riktig rekkeflge
	nodep oldoldself = S->_oldself;
	do 
	{
		_nearest_mon = -1;
		_turns_left--;
		_moves++;
		_H = 0;
		for (nodep* ip = _nodeb; ip < _nodee; ip++)
			if (_map->at(*ip) == MON)
				_mons.push_back(*ip);
		if (_self == NULL)
			break;
		_oldself = _self;
		nodep dest = _self->link(move);
		if (dest != NULL)
		{
			_eaten = _map->at(dest);
			if (true)//_eaten != MON)
			{
				_map->at(dest) = SELF;
				_map->at(_self) = OPEN;
				_self = dest;
				if (_firstself == NULL)
					_firstself = _self;
				switch (_eaten)
				{
				case COIN:  _coinc--;  break;
				case MCOIN: _mcoinc--; break;
				}
			}
		}
		else
			break;
	
		if (oldoldself == _self)
			_flipc++;
		_turn_bias += _oldself->rotation(oldoldself, _self);
		move_mon();
		find_fg();
		_beento->at(_self)++;
		nodep onwardn = _self->onward(_oldself);
		if (onwardn == NULL)
			break;
		move = _self->to(_self->onward(_oldself));
	}
	while (!_caught && clock() < timelimit && _turns_left && !_self->intersection() && (--maxi));
}
state::~state() { delete _map; delete _beento; }

void state::move_mon()
{
	list<nodep> mons_erase;
	list<nodep> mons_insert;
	for (list<nodep>::iterator it = _mons.begin(); it != _mons.end(); it++)
	{
		nodep mon = *it;
		astar::data monmove = astar::astar(mon, _self);
		nodep dest = mon->link(monmove.move);
		if (dest == NULL)
			continue;
		char dest_type = _map->at(dest);
		if (dest_type == MON)
			continue;
		if (dest == _self)
			_eaten_by_mon = true;
		if (monmove.dist < _nearest_mon || _nearest_mon == -1)
			_nearest_mon = monmove.dist;
		_map->at(dest) = MON;
		_map->at(mon) = dest_type;
		mons_erase.push_back(mon);
		mons_insert.push_back(dest);
	}
	for (list<nodep>::iterator it = mons_erase.begin();  it != mons_erase.end();  it++)		_mons.remove(*it); 
	for (list<nodep>::iterator it = mons_insert.begin(); it != mons_insert.end(); it++)		_mons.push_back(*it);
}

bool state::is_repeat()
{
	if (_prev == NULL)
		return false;

	state* p = _prev->_prev;
	if (p == NULL)
		return false;
	while (p->_prev != NULL)
	{
		if (*(_map) == *(p->_map))
			return true;
		p = p->_prev;
	}

	return false;
}

void state::find_fg()
{
	astar::data nearest_coin(CENTER, 0);
	astar::data nearest_mcoin(CENTER, 0);

	const int max_mon_dist = 5;
	if (_nearest_mon == -1)
	{
		if (!_mons.empty())
			_nearest_mon = astar::nearest(_self, _map, MON, max_mon_dist).dist;
		else
			_nearest_mon = 0;
	}
	else if (_nearest_mon > max_mon_dist)
		_nearest_mon = max_mon_dist;
	if (_coinc)
		nearest_coin = astar::nearest(_self, _map, COIN, 20);
	if (_mcoinc)
		nearest_mcoin = astar::nearest(_self, _map, MCOIN, 64);

	const int eaten_coin_reward = 36;// max(24-(_moves), 12);
	const int eaten_mcoin_reward = 500;
	const int eaten_mon_penalty = 2000;
	const int beento_penalty = 10;
	const int repeat_penalty = 100000;
	const int caught_penalty = 1200;
	const float mcoin_dist_penalty = nearest_mcoin.dist*16.0f - 64*16.0f;
//	const float mon_dist_penalty = 140.0f/(pow(float(_nearest_mon*5+1), 2))-35;

	_H += nearest_coin.dist*0.01f;
	_H += mcoin_dist_penalty;
//	_H += _moves - root_dist;
//	_H += (_moves - root_dist)*0.1;// + abs(_turn_bias)*6 ;
//	_H += mon_dist_penalty;
//	_H += _flipc*100;
//	_G += 1;
	_G += (_beento->at(_self)-'0')*beento_penalty;
	if (is_repeat())
		_G += repeat_penalty;
	if (!_mons.empty())
	{
		_caught = astar::caught(_self, _map, 4);
		if (_caught)
			_G += caught_penalty;
	}
	if (_eaten_by_mon)
		_G += eaten_mon_penalty;
	switch (_eaten)
	{
	case COIN:	_G -= eaten_coin_reward;  break;
	case MCOIN: _G -= eaten_mcoin_reward; break;
	case MON:	_G += eaten_mon_penalty;  break;
	}
}

void state::update_g()
{
	if (_nexts.size())
	{
		float _min_next_g = 1000000;
		for (list<state*>::iterator it = _nexts.begin(); it != _nexts.end(); it++)
		{
			(*it)->update_g();
			if (_min_next_g > (*it)->_G)
				_min_next_g = (*it)->_G;
		}
		if (_G < _min_next_g)
			_G = _min_next_g;
	}
}

bool state::operator==(const state& s) const
{
	if (_turns_left != s._turns_left || _w != s._w || _h != s._h)
		return false;
	if (_self == NULL || s._self == NULL)
		return false;
	if (_self->x != s._self->x || _self->y != s._self->y)
		return false;
	for (int y = 0; y < _h; y++)
		for (int x = 0; x < _w; x++)
			if (_map->at(x,y) != s._map->at(x,y))
				return false;
	return true;
}


inline int min(int a, int b) { return a < b ? a : b; }

namespace ai
{
	astar::data traceback(state* S)
	{
		state* p = S;
		state* pp = p;
		while (p->prev() != NULL)
		{
			pp = p;
			p = p->prev();
		}
		return astar::data(p->self()->to(pp->firstself()), S->moves());
	}
	typedef state* statep;
	class statep_comp 
	{ 
	public: 
		bool operator()(const statep& a, const statep& b) 
		{ return a->f() < b->f(); }
	};
	astar::data run(state* initial, int max_moves)
	{
		clock_t timelimit = clock() + clock_t(CLOCKS_PER_SEC*0.5);
		astar::priq<state*,statep_comp> queue;

		list<state*> states;
		list<state*> endstates;
		bool keepgoing = true;

		queue.push(initial);
		state* S;
		while(!queue.empty() && (keepgoing || endstates.size() < 8))// && states.size() < 4096)
		{
			S = queue.top();
			int moves = S->moves();
			if ( clock() > timelimit )
				break;
			queue.pop();
			if (!endstates.empty() && S->moves() == endstates.front()->moves())
				endstates.push_back(S);
			if (endstates.empty() || S->moves() > endstates.front()->moves())
			{
				endstates.clear();
				endstates.push_back(S);
			}
			if ( moves >= max_moves )
			{
				keepgoing = false;
				continue;
			}
			if ( S->f() > 1000 )
				continue;
			nodep self = S->self();
			for (int i = 0; i < 4; i++)
			{
				nodep link = self->link(i);
				if (link != NULL)
				{
					if (!S->mons() && S->prev() != NULL && link == S->prev()->self())
						continue;
					statep newS;
					newS = new state(S, self->to(link), 1, timelimit);
					queue.push(newS);
					states.push_back(newS);
					int moves_to_go = min(max_moves-newS->moves(),16);
					while (!newS->self()->intersection() && newS->moves() < max_moves && newS->f() < 1000)
					{
						nodep link2 = newS->self()->onward(newS->prev()->self());
						if (link2 == NULL)
							break;
						newS = new state(newS, newS->self()->to(link2), 4, timelimit);
						queue.push(newS);
						states.push_back(newS);
						moves_to_go--;
					}
				}
			}
		}
		list<state*>& checkstates = endstates.empty() ? states : endstates;
		initial->update_g();
		state* bestS = NULL;
		for (list<state*>::iterator it = states.begin(); it != states.end(); it++)
		{
			state* S = *it;
			if (bestS == NULL || S->f() < bestS->f())
				bestS = S;
		}
		astar::data result = traceback(bestS);
				// cleanup ? nh


		return result;
	}
}

int main(int argc, char* argv[])
{
	state start;

	if (start.self() == NULL)
	{
		printf("No X symbol!");
		return 1;
	}
	astar::data result = ai::run(&start, min(start.turns_left(), 120));

	printf("%c", result.move.as_char());
}
