/**
 * TG Hardcore programming compo
 * @author Christopher Olaussen
 * 
 * BF, and cutoffs
 * 
 */
import java.io.*;


/**
 * HackMan 
 * @author stOPHER
 */
class HackMan {
	
	public int x =-1;
	public int y =-1;
	
	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	HackMan(int x, int y) {
		this.x = x;
		this.y = y;
	}
}


/**
 * "AI" for HackMan
 * @author stOPHER
 */
public class AI_Java {

	static final char MAXHEIGHT 	= 64;
	static final char MAXWIDTH 		= 64;
	static final char MAXDIRECTIONS = 4;
	
	static boolean [][]   possiblePositions		= new boolean[MAXHEIGHT][MAXWIDTH];
	static boolean [][]   wallsPos				= new boolean[MAXHEIGHT][MAXWIDTH];
	static boolean [][]   monstersPos			= new boolean[MAXHEIGHT][MAXWIDTH];
	static boolean [][]   smallCoinPos			= new boolean[MAXHEIGHT][MAXWIDTH];
	static boolean [][]   bigCoinPos			= new boolean[MAXHEIGHT][MAXWIDTH];
	static boolean [][][] closestCoinMoves 		= new boolean[MAXHEIGHT][MAXWIDTH][MAXDIRECTIONS];
	
	final static int NORTH 	= 0;
	final static int SOUTH 	= 1;
	final static int EAST 	= 2;
	final static int WEST 	= 3;
	
	static int width 	= 0;
	static int height 	= 0;

	// init
	static {
		
		for(char y = 0; y < MAXHEIGHT; y++) {
			for(char x = 0; x < MAXWIDTH; x++) {
				for(char z = 0; z < MAXDIRECTIONS; z++) {
					closestCoinMoves[y][x][z] 	= false;
				}
				possiblePositions[y][x] 		= false;
				wallsPos[y][x] 					= false;
				smallCoinPos[y][x] 				= false;
				bigCoinPos[y][x] 				= false;
				monstersPos[y][x] 				= false;
			}			
		}
	}
	
	
	/**
	 * Go to specified direction
	 * @param direction
	 */
	private static void go(int direction) {
		
		if(direction == WEST) {
			goWest();
		} else if(direction == NORTH) {
			goNorth();
		} else if(direction == EAST) {
			goEast();
		} else if(direction == SOUTH) {
			goSouth();
		} else {
			System.out.println("direction error:"+direction);
		}
	}
	
	/**
	 * Checks if possible position and not dead end
	 * @param x
	 * @param y
	 */
	private static boolean  isOkPosition(int x, int y, int direction) {
		
		if(wallsPos[y][x]) {
			return false;
		}
		
		if(((x < width) && (x >= 0)) && ((y < height) && (y >= 0))) {
			if(possiblePositions[y][x]) {
				return true;
			} else {
				return false;
			}			
		} else {
			return false;
		}	
	}
	

	
	/**
	 * Get steps to closest Coin
	 * @param newX
	 * @param newY
	 * @param newDir
	 * @param totalSteps
	 * @return steps to coin
	 */
	private static int closestCoin(int newX, int newY, int newDir, int totalSteps) {
		
		if(totalSteps > 256) {
			return Integer.MAX_VALUE;
		}
		
		closestCoinMoves[newY][newX][newDir] = true;
		
		if(!isOkPosition(newX, newY, newDir)) {
			return Integer.MAX_VALUE;
		}
		
		if(bigCoinPos[newY][newX]) {
			return (++totalSteps);
		} else if (smallCoinPos[newY][newX]) {						
			return (++totalSteps);
		} else {
			
			int found = Integer.MAX_VALUE;
			int eF = Integer.MAX_VALUE;
			int wF = Integer.MAX_VALUE;
			int sF = Integer.MAX_VALUE;
			int nF = Integer.MAX_VALUE;
			
			if(isOkPosition((newX+1), newY, EAST)  			&& (!closestCoinMoves[newY][(newX+1)][EAST])) {
				eF = closestCoin((newX+1), newY, EAST, ++totalSteps);
			}  else if (isOkPosition((newX-1), newY, WEST) 	&& (!closestCoinMoves[newY][(newX-1)][WEST])) {
				wF = closestCoin(newX-1,newY,WEST,++totalSteps);
			} else if(isOkPosition(newX, (newY+1), NORTH) 	&& (!closestCoinMoves[newY+1][(newX)][NORTH])) {
				nF = closestCoin(newX,newY+1,NORTH,++totalSteps);
			} else if (isOkPosition(newX, (newY-1), SOUTH) 	&& (!closestCoinMoves[newY-1][(newX)][SOUTH])) {
				sF = closestCoin(newX,(newY-1),SOUTH,++totalSteps);
			}
			
			found = eF;
			if(wF < found) {
				found = wF;
			}
			if(sF < found) {
				found = sF;
			}
			if(nF < found) {
				found = nF;
			}
			return found;			
		}
	}
	
	// kickoff
	public static void main(String argv[]) throws IOException {
		
				
		// Parses the input
		BufferedReader stdin = new BufferedReader(
				new InputStreamReader(System.in));

		int movesLeft = Integer.parseInt(stdin.readLine());
		width = Integer.parseInt(stdin.readLine());
		height = Integer.parseInt(stdin.readLine());

		char[][] grid = new char[height][width];
		
		
		for (int y = 0; y < height; y++) {
				grid[y] = stdin.readLine().toCharArray();
		}
		

		
		HackMan hackMan = null;
		
		int smallCoinsSum = 0;
		int bigCoinsSum = 0;
		
		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				
					if(grid[y][x] == 'M') {
						possiblePositions[y][x] = true;
						monstersPos[y][x] = true;
					
					} else if (grid[y][x] == 'o') {
						possiblePositions[y][x] = true;
						bigCoinPos[y][x] = true;
						bigCoinsSum++;
					
					} else if (grid[y][x] == '.') {
						possiblePositions[y][x] = true;
						smallCoinPos[y][x] = true;
						smallCoinsSum++;
						
					} else if (grid[y][x] == 'X') {
						hackMan = new HackMan(x,y);
						possiblePositions[y][x] = true;
					} else if (grid[y][x] == '#'){
						wallsPos[y][x] = true;
					} else if (grid[y][x] == ' '){
						possiblePositions[y][x] = true;
					}
			}
		}

			
		boolean enemyAboveS1 = false;
		boolean enemyBelowS1 = false;
		boolean enemyLeftS1  = false;
		boolean enemyRightS1 = false;
		boolean enemyAboveS2 = false;
		boolean enemyBelowS2 = false;
		boolean enemyLeftS2  = false;
		boolean enemyRightS2 = false;
		
				
		// above step 1
		if((hackMan.y-1 >= 0)) {
			
			if(monstersPos[hackMan.y-1][hackMan.x]) {
				enemyAboveS1 = true;
			}
			
			if((hackMan.x+1 < width)) {
				if(monstersPos[hackMan.y-1][hackMan.x+1]) {
					enemyAboveS1 =true;
				}
			}
			
			if((hackMan.x-1 >= 0)) {
				if(monstersPos[hackMan.y-1][hackMan.x-1]) {
					enemyAboveS1 =true;
				}
			}
		}		
		
		// above step 2
		if((hackMan.y-2) >= 0) {
			
			if(monstersPos[hackMan.y-2][hackMan.x]) {
				enemyAboveS2 = true;
			}
			
			if(hackMan.x+2 < width){
				if(monstersPos[hackMan.y-2][hackMan.x+2]) {
					enemyAboveS2 = true;
				}
			}
			if(hackMan.x+1 < width){
				if(monstersPos[hackMan.y-2][hackMan.x+1]) {
					enemyAboveS2 = true;
				}
			}
			
			if(hackMan.x-2 >= 0) {
				if(monstersPos[hackMan.y-2][hackMan.x-2]) {
					enemyAboveS2 = true;
				}
			}
			
			if((hackMan.x-1 >=0)) {
				if(monstersPos[hackMan.y-2][hackMan.x-1]) {
					enemyAboveS2 = true;
				}
			}				
		}	
		if(hackMan.y-1 >= 0) {
			
			if((hackMan.x-2 >= 0)) {
				if(monstersPos[hackMan.y-1][hackMan.x-2]) {
					enemyAboveS2 = true;
				}
			}
				
			if(hackMan.x+2 < width) {
				if(monstersPos[hackMan.y-1][hackMan.x+2]) {
					enemyAboveS2 = true;
				}
			}			
		}

			
		
		// below s1
		if(hackMan.y+1 < height) {
			
			if(monstersPos[hackMan.y+1][hackMan.x]) {
				enemyBelowS1 = true;
			}
			
			if(hackMan.x+1 <width) {
				if(monstersPos[hackMan.y+1][hackMan.x+1]) {
					enemyBelowS1 = true;
				}
			}
			if(hackMan.x-1 >=0) {
				if(monstersPos[hackMan.y+1][hackMan.x-1]) {
					enemyBelowS1 = true;
				}
			}
		}
		
		// below s2
		if(hackMan.y+2 < height) {
			
			if(monstersPos[hackMan.y+2][hackMan.x]) {
				enemyBelowS2 = true;
			}
			
			if(hackMan.x+2 < width) {
				if(monstersPos[hackMan.y+2][hackMan.x+2]) {
					enemyBelowS2 = true;
				}
			}
			if(hackMan.x+1 < width) {
				if(monstersPos[hackMan.y+2][hackMan.x+1]) {
					enemyBelowS2 = true;
				}
			}
			if(hackMan.x-2 >=0) {
				if(monstersPos[hackMan.y+2][hackMan.x-2]) {
					enemyBelowS2 = true;
				}
			}
			if(hackMan.x-1 >=0) {
				if(monstersPos[hackMan.y+2][hackMan.x-1]) {
					enemyBelowS2 = true;
				}
			}
		}
		
		if(hackMan.y+1 < height) {
			if(hackMan.x-2 >=0) {
				if(monstersPos[hackMan.y+1][hackMan.x-2]) {
					enemyBelowS2 = true;
				}
			}
			if((hackMan.x+2 < width)) {
				if(monstersPos[hackMan.y+1][hackMan.x+2]) {
					enemyBelowS2 = true;
				}
			}
		}
		
		// right s1
		if(hackMan.x+1 < width) {
			if(monstersPos[hackMan.y][hackMan.x+1]) {
				enemyRightS1 = true;
			}
		}
	
		// right s2
		if(hackMan.x+2 < width) {
			if(monstersPos[hackMan.y][hackMan.x+2]) {
				enemyRightS2 = true;
			}
		}
		
		// left s1
		if(hackMan.x-1 >=0) {
			if(monstersPos[hackMan.y][hackMan.x-1]) {
				enemyLeftS1 = true;
			}
		}
		
		// left s2
		if(hackMan.x-2 >=0) {
			
			if(monstersPos[hackMan.y][hackMan.x-2]) {
				enemyLeftS2 = true;
			}
		}
		

		
		// handle enemy warnings or move along
		if(enemyAboveS1 || enemyAboveS2) { 
			enemyAboveS1(grid, hackMan, width, height);
		}
		else if(enemyBelowS1 || enemyBelowS2) {
			enemyBelowS1(grid, hackMan, width, height);
		}
		else if(enemyRightS1 || enemyRightS2) {
			enemyRightS1(grid, hackMan, width, height);
		}
		else if(enemyLeftS1 || enemyLeftS2) {
			enemyLeftS1(grid, hackMan, width, height);
		} else {
			findCoinAndMove(hackMan, -1);
		}
		
	}	
	
	
	static void goEast() {
		System.out.print("E");
		System.exit(0);
	}
	
	static void goWest() {
		System.out.print("W");
		System.exit(0);
	}
	
	static void goSouth() {
		System.out.print("S");
		System.exit(0);
	}
	
	static void goNorth() {
		System.out.print("N");
		System.exit(0);
	}
	
	/**
	 * Reset moves when
	 * searching for coins
	 */
	static void resetCoinMoves() {
		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				for(char z = 0; z < MAXDIRECTIONS; z++) {

					closestCoinMoves[y][x][z] = false;				
				}
			}
		}
	}
	
	/**
	 * Locate nearest coin and move
	 * @param hackMan
	 * @param escaping from?
	 */
	static void findCoinAndMove(HackMan hackMan, int escaping) {
		
			
		int hackX = hackMan.x;
		int hackY = hackMan.y;
		
		resetCoinMoves();
		int westClosestCoin 	= closestCoin((hackX-1),hackY, WEST,0); 
		resetCoinMoves();
		int northClosestCoin 	= closestCoin(hackX,(hackY-1), NORTH,0);
		resetCoinMoves();
		int southClosestCoin 	= closestCoin(hackX, (hackY+1),  SOUTH,0);
		resetCoinMoves();
		int eastClosestCoin 	= closestCoin((hackX+1), hackY,  EAST,0);
		resetCoinMoves();
		
		int biggest = Integer.MAX_VALUE;
		int bestDirection = NORTH;
		
		if(southClosestCoin < biggest) {
			bestDirection = SOUTH;
			biggest = southClosestCoin;
		}
		if(westClosestCoin < biggest) {
			bestDirection = WEST;
			biggest = westClosestCoin;
		}
		if(northClosestCoin < biggest) {
			bestDirection = NORTH;
			biggest = northClosestCoin;
		}		
		if(eastClosestCoin < biggest) {
			bestDirection = EAST;
			biggest = eastClosestCoin;
		}	
		biggest = bestDirection;
		
		
		if(((westClosestCoin != Integer.MAX_VALUE) || (southClosestCoin != Integer.MAX_VALUE) || (northClosestCoin != Integer.MAX_VALUE) || (eastClosestCoin != Integer.MAX_VALUE)) && (escaping == -1)) {
			go(biggest);
		} else {
	
			if(escaping == NORTH) {
				
				if(isOkPosition( hackX,(hackY+1) , SOUTH)) {
					if(smallCoinPos[(hackY+1)][hackX] || bigCoinPos[(hackY+1)][hackX]) {
						goSouth();
						return;
					}
				} 
				if(isOkPosition( (hackX+1),hackY, EAST)) {
					if(smallCoinPos[hackY][(hackX+1)] || bigCoinPos[hackY][(hackX+1)]) {
						goEast();
						return;
					}
				}
				
				if(isOkPosition( (hackX-1),hackY, WEST)) {
					if(smallCoinPos[hackY][(hackX-1)] || bigCoinPos[hackY][ (hackX-1)]) {
						goWest();
						return;
					}
				}
				
				if(isOkPosition( hackX, (hackY+1), SOUTH)) {
					goSouth();
				} else if(isOkPosition( (hackX-1),hackY, WEST)) {
					goWest();
				}else if(isOkPosition( (hackX+1),hackY, EAST)) {
					goEast();
				} 				
				
				if(isOkPosition( hackX,(hackY-1), NORTH)) {
					if(smallCoinPos[(hackY-1)][hackX] || bigCoinPos[(hackY-1)][hackX]) {
						goNorth();
						return;
					}
				}
				
				if(isOkPosition( hackX,(hackY-1), NORTH)) {
					goNorth();
				}  				
				
			} else if(escaping == SOUTH) {

				if(isOkPosition( (hackX+1),hackY, EAST)) {
					if(smallCoinPos[hackY][(hackX+1)] || bigCoinPos[hackY][(hackX+1)]) {
						goEast();
						return;
					}
				}
				if(isOkPosition( (hackX-1),hackY, WEST)) {
					if(smallCoinPos[hackY][(hackX-1)] || bigCoinPos[hackY][ (hackX-1)]) {
						goWest();
						return;
					}
				}
				if(isOkPosition( hackX,(hackY-1), NORTH)) {
					if(smallCoinPos[(hackY-1)][hackX] || bigCoinPos[(hackY-1)][hackX]) {
						goNorth();
						return;
					}
				}
				
				if(isOkPosition( hackX,(hackY-1), NORTH)) {
					goNorth();
				}  else if(isOkPosition( (hackX-1),hackY, WEST)) {
					goWest();
				}else if(isOkPosition( (hackX+1),hackY, EAST)) {
					goEast();
				} 
				
				if(isOkPosition( hackX,(hackY+1) , SOUTH)) {
					if(smallCoinPos[(hackY+1)][hackX] || bigCoinPos[(hackY+1)][hackX]) {
						goSouth();
						return;
					}
				} 	
				
				if(isOkPosition( hackX, (hackY+1), SOUTH)) {
					goSouth();
				} 				
				
			} else if(escaping == WEST) {
				
				if(isOkPosition( (hackX+1),hackY, EAST)) {
					if(smallCoinPos[hackY][(hackX+1)] || bigCoinPos[hackY][(hackX+1)]) {
						goEast();
						return;
					}
				}

				if(isOkPosition( hackX,(hackY-1), NORTH)) {
					if(smallCoinPos[(hackY-1)][hackX] || bigCoinPos[(hackY-1)][hackX]) {
						goNorth();
						return;
					}
				}
				if(isOkPosition( hackX,(hackY+1) , SOUTH)) {
					if(smallCoinPos[(hackY+1)][hackX] || bigCoinPos[(hackY+1)][hackX]) {
						goSouth();
						return;
					}
				} 				

				if(isOkPosition( hackX,(hackY-1), NORTH)) {
					goNorth();
				} else if(isOkPosition( (hackX+1),hackY, EAST)) {
					goEast();
				}  else if(isOkPosition( hackX, (hackY+1), SOUTH)) {
					goSouth();
				}
				
				if(isOkPosition( (hackX-1),hackY, WEST)) {
					if(smallCoinPos[hackY][(hackX-1)] || bigCoinPos[hackY][ (hackX-1)]) {
						goWest();
						return;
					}
				}	
				
				if(isOkPosition( (hackX-1),hackY, WEST)) {
					goWest();
				}
				
			} else if(escaping == EAST) {
				

				if(isOkPosition( (hackX-1),hackY, WEST)) {
					if(smallCoinPos[hackY][(hackX-1)] || bigCoinPos[hackY][ (hackX-1)]) {
						goWest();
						return;
					}
				}
				if(isOkPosition( hackX,(hackY-1), NORTH)) {
					if(smallCoinPos[(hackY-1)][hackX] || bigCoinPos[(hackY-1)][hackX]) {
						goNorth();
						return;
					}
				}
				if(isOkPosition( hackX,(hackY+1) , SOUTH)) {
					if(smallCoinPos[(hackY+1)][hackX] || bigCoinPos[(hackY+1)][hackX]) {
						goSouth();
						return;
					}
				} 
				
					if(isOkPosition( hackX,(hackY-1), NORTH)) {
						goNorth();
					}  else if(isOkPosition( hackX, (hackY+1), SOUTH)) {
						goSouth();
					} else if(isOkPosition( (hackX-1),hackY, WEST)) {
						goWest();
					}
					
					if(isOkPosition( (hackX+1),hackY, EAST)) {
						if(smallCoinPos[hackY][(hackX+1)] || bigCoinPos[hackY][(hackX+1)]) {
							goEast();
							return;
						}
					}					
					
					if(isOkPosition( (hackX+1),hackY, EAST)) {
						goEast();
					} 
			} else {
				if(isOkPosition( (hackX-1),hackY, WEST)) {
					goWest();
				} else if(isOkPosition( hackX,(hackY-1), NORTH)) {
					goNorth();
				} else if(isOkPosition( hackX, (hackY+1), SOUTH)) {
					goSouth();
				} else if(isOkPosition( (hackX+1),hackY, EAST)) {
					goEast();
				} else {
					System.out.println("WEIRD ERROR");
				}
			}
		}
	}
	
	static void enemyAboveS1(char[][] grid, HackMan hackMan, int width, int height) {
		
	
		if(hackMan.y-1 >= 0) {
			if(!wallsPos[hackMan.y-1][hackMan.x] && !(monstersPos[hackMan.y-1][hackMan.x])) {
					
				findCoinAndMove(hackMan, NORTH);
				return;
			}
		}
		
		if(hackMan.x-1 >= 0) {
			if(!wallsPos[hackMan.y][hackMan.x-1] && !(monstersPos[hackMan.y][hackMan.x-1])) {
				findCoinAndMove(hackMan, NORTH);
				return;
			}
		}	


		if((hackMan.x+1 < width)) {
			if(!wallsPos[hackMan.y][hackMan.x+1] && !(monstersPos[hackMan.y][hackMan.x+1])) {
				findCoinAndMove(hackMan, NORTH);
				return;
			}
		}				


		if((hackMan.y+1 < height)) {
			if(!wallsPos[hackMan.y+1][hackMan.x] && !(monstersPos[hackMan.y+1][hackMan.x])) {
				findCoinAndMove(hackMan, NORTH);
				return;
			}
		}
		
		return;		
	}
	
	static void enemyBelowS1(char[][] grid, HackMan hackMan, int width, int height) {
		
		if((hackMan.y+1 < height)) {
			if(!wallsPos[hackMan.y+1][hackMan.x] && !(monstersPos[hackMan.y+1][hackMan.x])) {
				findCoinAndMove(hackMan, SOUTH);
				return;
			}
		}	
		
		if((hackMan.x+1 < width)) {
			if(!wallsPos[hackMan.y][hackMan.x+1] && !(monstersPos[hackMan.y][hackMan.x+1])) {
				findCoinAndMove(hackMan, SOUTH);
				return;
			}
		}
		
		if(hackMan.x-1 >= 0) {
			if(!wallsPos[hackMan.y][hackMan.x-1] && !(monstersPos[hackMan.y][hackMan.x-1])) {
				findCoinAndMove(hackMan, SOUTH);
				return;
			}
		}	

		if(hackMan.y-1 >= 0) {
			if(!wallsPos[hackMan.y-1][hackMan.x] && !(monstersPos[hackMan.y-1][hackMan.x])) {
				findCoinAndMove(hackMan, SOUTH);
				return;
			}
		}

		return;	
	}	
	
	static void enemyLeftS1(char[][] grid, HackMan hackMan, int width, int height) {

		
		if((hackMan.x+1 < width)) {
			if(!wallsPos[hackMan.y][hackMan.x+1] && !(monstersPos[hackMan.y][hackMan.x+1])) {
				findCoinAndMove(hackMan, WEST);
				return;
			}
		}
		
		if((hackMan.y+1 < height)) {
			if(!wallsPos[hackMan.y+1][hackMan.x] && !(monstersPos[hackMan.y+1][hackMan.x])) {
				findCoinAndMove(hackMan, WEST);
				return;
			}
		}	

		if(hackMan.y-1 >= 0) {
			if(!wallsPos[hackMan.y-1][hackMan.x] && !(monstersPos[hackMan.y-1][hackMan.x])) {
				findCoinAndMove(hackMan, WEST);
				return;
			}
		}		
		
		if(hackMan.x-1 >= 0) {
			if(!wallsPos[hackMan.y][hackMan.x-1] && !(monstersPos[hackMan.y][hackMan.x-1])) {
				findCoinAndMove(hackMan, WEST);
				return;
			}
		}	

		return;	
	}	
	
	static void enemyRightS1(char[][] grid, HackMan hackMan, int width, int height) {
		
		
		if(hackMan.x-1 >= 0) {
			if(!wallsPos[hackMan.y][hackMan.x-1] && !(monstersPos[hackMan.y][hackMan.x-1])) {
				findCoinAndMove(hackMan, EAST);
				return;
			}
		}
		if(hackMan.y-1 >= 0) {
			if(!wallsPos[hackMan.y-1][hackMan.x] && !(monstersPos[hackMan.y-1][hackMan.x])) {
				findCoinAndMove(hackMan, EAST);
				return;
			}
		}	
		if((hackMan.y+1 < height)) {
			if(!wallsPos[hackMan.y+1][hackMan.x] && !(monstersPos[hackMan.y+1][hackMan.x])) {
				findCoinAndMove(hackMan, EAST);
				return;
			}
		}	

	
		if((hackMan.x+1 < width)) {
			if(!wallsPos[hackMan.y][hackMan.x+1] && !(monstersPos[hackMan.y][hackMan.x+1])) {
				findCoinAndMove(hackMan, EAST);
				return;
			}
		}		

		return;	
	}	
}
