import java.io.*;

public class Hackman {

	
	private int movesLeft;
	private int width;
	private int height;
	private int playerX;
	private int playerY;

	char[][] grid;
	
	public Hackman() throws NumberFormatException, IOException{
		BufferedReader stdin = new BufferedReader(
				new InputStreamReader(System.in));

		movesLeft = Integer.parseInt(stdin.readLine());
		width = Integer.parseInt(stdin.readLine());
		height = Integer.parseInt(stdin.readLine());
		
		grid = new char[height][width];
		
		for (int y = 0; y < height; y++) {
				grid[y] = stdin.readLine().toCharArray();
		}
		
		//Set Player coords
		for(int y = 0; y < height; y++){
			for(int x = 0; x < width; x++){
				if(grid[y][x]=='X'){
					playerX = x;
					playerY = y;
					break;
				}
			}
		}
	}
	
	//Determines if we can move direction c
	public boolean canMove(char c){
		switch(c){
			case 'N':
				if(grid[playerY-1][playerX] != 'M' && grid[playerY-1][playerX] != '#' && playerY != 0){
					return true;
				}
				return false;
			case 'S':
				if(grid[playerY+1][playerX] != 'M' && grid[playerY+1][playerX] != '#' && playerY != grid.length-1){
					return true;
				}
				return false;
			case 'E':
				if(grid[playerY][playerX+1] != 'M' && grid[playerY][playerX+1] != '#' && playerX != grid[0].length){
					return true;
				}
				return false;
			case 'W':
				if(grid[playerY][playerX-1] != 'M' && grid[playerY][playerX-1] != '#' && playerX != 0){
					return true;
				}
				return false;
		}
		return false;
	}
	
	//return the direction to go for the nearest 'o' coin and after that the nearest '.' coin
	public char nearestCoin(){
		int coinx = -1;
		int coiny = -1;
		for(int y = 0; y < height; y++){
			for(int x = 0; x < width; x++){
				if(grid[y][x]=='o' && ((Math.abs(x-playerX)+Math.abs(y-playerY)) < ((Math.abs(coinx-playerX))+Math.abs(coiny-playerY)))){
					coinx = x;
					coiny = y;
				}
			}
		}
		if(coinx == -1){
			for(int y = 0; y < height; y++){
				for(int x = 0; x < width; x++){
					if(grid[y][x]=='.' && ((Math.abs(x-playerX)+Math.abs(y-playerY)) < ((Math.abs(coinx-playerX))+Math.abs(coiny-playerY)))){
						coinx = x;
						coiny = y;
					}
				}
			}
		}
		if(coinx < playerX && canMove('W')){
			return 'W';
		}
		else if(coinx > playerX && canMove('E')){
			return 'E';
		}
		else if(coiny < playerY && canMove('N')){
			return 'N';
		}
		else if(coiny > playerY && canMove('S')){
			return 'S';
		}
		else{
			int move = (int) (4 * Math.random());
			switch (move){
				case 0:
					return 'E';
				case 1:
					return 'W';
				case 2:
					return 'S';
				case 3:
					return 'N';
			}
		}
		return ' ';
	}
	
	public char monsterInRange(){
		int checkyf;//from y
		int checkxt;//to x
		int checkyt;//to y
		int checkxf;//from x
		//Check that we don`t get out of range
		if(playerY != 0){
			if(playerY - 1 != 0){
				checkyf = playerY -2;
			}
			else{
				checkyf = playerY -1;
			}
		}
		else{
			checkyf = playerY;
		}
		if(playerX != 0){
			if(playerX - 1 != 0){
				checkxf = playerX -2;
			}
			else{
				checkxf = playerX -1;
			}
		}
		else{
			checkxf = playerX;
		}
		if(playerY != height-1){
			if(playerY + 1 != height-1){
				checkyt = playerY +2;
			}
			else{
				checkyt = playerY +1;
			}
		}
		else{
			checkyt = playerY;
		}
		if(playerX != width-1){
			if(playerX + 1 != width-1){
				checkxt = playerX +2;
			}
			else{
				checkxt = playerX +1;
			}
		}
		else{
			checkxt = playerX;
		}
		//Find first monster and determines the fastest direction away from it
		//TODO Get it to "see" forward for other monsters than the nearest
		for(int y = checkyf; y < checkyt; y++){
			for(int x = checkxf; x < checkxt; x++){
				if(grid[y][x] == 'M'){
					if(y < playerY){
						if(x == playerX){
								return 'S';
						}
					}
					if(y > playerY){
						if(x == playerX){
								return 'N';
							
						}
					}
					if(x < playerX){
							return 'E';
						
					}
					if(x > playerX){
							return 'W';
						
					}
				}
			}
		}
		return nearestCoin();
	}
	
	public int getHeight() {
		return height;
	}

	public int getPlayerX() {
		return playerX;
	}

	public int getPlayerY() {
		return playerY;
	}

	public char getGrid(int y, int x){
		return grid[y][x];
	}
	/**
	 * @param args
	 * @throws IOException 
	 * @throws NumberFormatException  
	 */
	public static void main(String[] args) throws NumberFormatException, IOException{

		// Parses the input
		Hackman h = new Hackman();
		
		char m = h.monsterInRange();
		
			switch(m){
			case 'N':
				if(!h.canMove('N')){				
					if(!h.canMove('E')){
						if(!h.canMove('W')){
							System.out.println(" ");
						}
						else{
							System.out.println("W");
						}
					}
					else{
						System.out.println("E");
					}
				}
				else{
					System.out.println("N");
				}
				break;
			case 'S':
				if(!h.canMove('S')){				
					if(!h.canMove('E')){
						if(!h.canMove('W')){
							System.out.println(" ");
						}
						else{
							System.out.println("W");
						}
					}
					else{
						System.out.println("E");
					}
				}
				else{					
					System.out.println("S");
				}
				break;
			case 'E':
				if(!h.canMove('E')){				
					if(!h.canMove('N')){
						if(!h.canMove('S')){
							System.out.println(" ");
						}
						else{
							System.out.println("S");
						}
					}
					else{
						System.out.println("N");
					}
				}
				else{
					System.out.println("E");
				}
				break;
			case 'W':
				if(!h.canMove('W')){				
					if(!h.canMove('S')){
						if(!h.canMove('N')){
							System.out.println(" ");
						}
						else{
							System.out.println("N");
						}
					}
					else{
						System.out.println("S");
					}
				}
				else{
					System.out.println("W");
				}
		}
	}
}
