uniform sampler2D tonemappedTexture;
uniform sampler2D bloomTexture;
uniform sampler1D gammaRamp;

uniform sampler2D noise;


uniform vec2 mouse;

void main()
{	
	vec2 p = gl_TexCoord[0].xy;
	vec3 main = texture2D(tonemappedTexture, p).rgb;
	vec3 bloom = texture2D(bloomTexture, p).rgb;	
	vec3 noiseSample = texture2D(noise, p).rgb;	
	
	vec2 dist = (p - vec2(0.5,0.5)) * vec2(2.0) - mouse;
	float d2 = dist.x * dist.x + dist.y * dist.y;
	float lum = max(0.0, 0.8 + 0.4 *  exp(-d2 * 6.0));
	vec3 preGammaColor = (main + bloom + vec3(-0.05) + vec3(0.1) * noiseSample ) * vec3(lum);
	
	/* now with tables */	
	
	float red = texture1D(gammaRamp, preGammaColor.r).x;
	float green = texture1D(gammaRamp, preGammaColor.g).x;
	float blue = texture1D(gammaRamp, preGammaColor.b).x;
	
	gl_FragColor = vec4( vec3(red, green, blue), 1.0);
	
}

