unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, math;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Image1: TImage;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  arr_tr:array [0..255] of byte;
  i: real;
  j,len,lnsel: integer;
  b:byte;
  step1,step2,step3,rad1,rad2,rad3:integer;
  step4,step5,step6,rad4,rad5,rad6:integer;
  F1,F2: file of byte;
implementation

{$R *.dfm}
procedure RedrawLine;
begin
Form1.Image1.Canvas.Brush.Color:=clBtnFace;
Form1.Image1.Canvas.FillRect(Rect(0,0,
Form1.Image1.Width,Form1.Image1.Height));
Form1.Image1.Canvas.Brush.Color:=clWhite;
Form1.Image1.Canvas.FillRect(Rect(0,0,
len*4,Form1.Image1.Height));

Form1.Image1.Canvas.Brush.Color:=RGB(255,200,200);
Form1.Image1.Canvas.FillRect(Rect(lnsel*4,0,
lnsel*4+4,Form1.Image1.Height));

for j:=0 to len-1 do
  begin
 Form1.Image1.Canvas.Brush.Color:=clBlack;
 Form1.Image1.Canvas.FillRect(Rect(j*4,arr_tr[j]*4,j*4+4,arr_tr[j]*4+4));
  end;
end;
procedure TForm1.Button1Click(Sender: TObject);
begin
len:=0;
step1:=32; rad1:=19;
step2:=32; rad2:=13;  //8*4
step3:=32; rad3:=19; //12*4
step4:=16; rad4:=8; //12*4
step5:=8; rad5:=4; //12*4
step6:=4; rad6:=2; //12*4

i:=0;
while i<90 do
  begin
  arr_tr[len]:=trunc(rad1*sin(pi*i/180));
  Inc(len);
  i:=i+90/step1;
  end;

i:=90;
while i>-90 do
  begin
  arr_tr[len]:=trunc((24-rad2)+(rad2/2)*sin(pi*i/180));
  Inc(len);
  i:=i-180/(step2);
  end;

i:=90;
while i>=0 do
  begin
  arr_tr[len]:=trunc(3+rad3-rad3*sin(pi*i/180));
  Inc(len);
  i:=i-90/step3;
  end;

//---- 
i:=0;
While i<180 do
  begin
  arr_tr[len]:=trunc(22-rad4*sin(pi*i/180));
  Inc(len);
  i:=i+180/step4;
  end;
i:=0;
While i<180 do
  begin
  arr_tr[len]:=trunc(22-rad5*sin(pi*i/180));
  Inc(len);
  i:=i+180/step5;
  end;
i:=0;
While i<=180 do
  begin
  arr_tr[len]:=trunc(22-rad6*sin(pi*i/180));
  Inc(len);
  i:=i+180/step6;
  end;
RedrawLine;
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
lnsel:=floor(x/4);
RedrawLine;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
Dec(arr_tr[lnsel]);
RedrawLine;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
Inc(arr_tr[lnsel]);
RedrawLine;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
AssignFile (F1,'lntbl1.tbl');
ReWrite(F1);
AssignFile (F2,'lntbl2.tbl');
ReWrite(F2);
for j:=0 to len-1 do
  begin
  Write(F1,arr_tr[j]);
  b:=22-arr_tr[j]; Write(F2,b);
  end;
  Button1.Caption:=IntToStr(arr_tr[len-1]);
CloseFile(F1);
CloseFile(F2);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
Dec(len);
RedrawLine;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
Inc(len);
RedrawLine;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
AssignFile (F1,'lntbl1.tbl');
Reset(F1);
len:=0;
While (not(eof(F1))) do
  begin
  Read(F1,arr_tr[len]);
  Inc(len);
  end;
CloseFile(F1);
RedrawLine;
end;

end.
