imports System
imports System.drawing

Public Class Effect
    private g as Graphics
    private canvas as Bitmap
    private background as Bitmap
    private overlay as Bitmap
    private overlayYOffset as Integer
    private cursorColor as Color
    private cursorBrush as Brush
    private cursorPen as Pen
    
    Public Sub New()
        canvas = New Bitmap(256, 256, System.Drawing.Imaging.PixelFormat.Format32bppArgb)
        g = Graphics.FromImage(canvas)
        background = New Bitmap("../data/kuusnepa.png")
        overlay = New Bitmap("../data/scrolltext.png")
        overlayYOffset = 160
        cursorColor = Color.FromArgb(95, 88, 253)
        cursorBrush = new SolidBrush(cursorColor)
    End Sub

    Private Function compose(offset as Integer) As Bitmap
        g.DrawImage(background, 0, 0)
        g.DrawImage(overlay, offset, overlayYOffset)
        g.DrawImage(overlay, offset + overlay.width, overlayYOffset)
        g.DrawImage(overlay, offset - overlay.width, overlayYOffset)
        Return canvas
    end Function

    Private Function drawCursor() as Bitmap
        g.fillRectangle(cursorBrush, 28, 107, 5, 6)
        return canvas
    end Function

    public Function render(timeInMillis as Integer) as Bitmap
        Dim wrapTime as Integer = 4000
        Dim curTime as Integer = timeInMillis mod wrapTime
        Dim offset as Integer
        Dim output as Bitmap
        offset = CInt(-CDbl(curTime)/wrapTime * overlay.width)
        output = compose(offset)
        If timeInMillis mod 2000 < 1000 Then
          output = drawCursor()
        end If
        output.save("vb-out.bmp", System.Drawing.Imaging.ImageFormat.Bmp)
        return output
    end Function
end Class
