module SceneBlock6 (b6_rawscenes) where

import Data.Vec hiding (map, length, take)
import Util
import System.Random
import LameShuffle

popular_nicks = ["epeli","Snattu","Eladith","Ziticca","deggis","jypa","zipola","Apsup","Rakeinen","zouppen","Katajakasa","centralnoise"]
other_nicks = ["mobliz","Kaelum","batalyx","Hekku2","arthuuro","Auroch","Kivi","hyder","Maija","Thieffi","Cornix","Artanicus","jontsi","AirZero","Psygnolla","Lanttu","Gotsy","Lucyfer","Teistiz","rajumiika","Zeggo","Tinuzka","vlb-","Hazler","tuos","hanshoi","TuPe","Kape","Jorer","B4K4","Sipuli","Katis","louk","Karppo","raaste","tekr","mmahh","netspider","PunGary","mikkotus","JuhoAP","Maakuth","kaviaari","Stugane","ville_salonen","zov","Tetraedri","Etsubu","katte","TheMansel","Miltton","Mr. MikroPoint","Lilya","Elos","waffle","Ajaska","Katya","Laurs","Jybl","jaakkop","ane"]

nicks :: [(String, Float)]
nicks = concat [populars,normals]
populars = zip popular_nicks $ repeat 0.7
normals = zip other_nicks $ repeat 0.3

rand x = (\(value, gen) -> value) (random (mkStdGen (x * 117)) :: (Float, StdGen))
--onedim n d = [rand x | x <- [(1+(n*d))..(n+(n*d))]]
onedim :: Int -> Int -> [Float]
onedim n d = take n $ randomRs((-0.8),0.8) (mkStdGen $ d * 117)::[Float]

twodim :: Int -> [(Float, Float)]
twodim n = zip (onedim n 0) (onedim n 1)



randPos :: [(Float, Float)] -> [Vec2 Float]
randPos input = map (\(x,y) -> (x:.y:.())) input

addTimeAndPos :: [(String, Float)] -> [(String, Float, Float, Vec2 Float)]
addTimeAndPos input = zip3' nicks (generateTimes (length nicks)) (randPos $ twodim $ length nicks)

generateTimes :: Int -> [Float]
generateTimes n = shuffle (mkStdGen 10) $ elementSum satunnaisuus sarja
  where satunnaisuus = onedim n (n + 5)
        sarja = [fromIntegral (x * 4) | x <- [1..n]]

elementSum :: Fractional a => [a] -> [a] -> [a]
elementSum [] _ = []
elementSum _ [] = []
elementSum (x:xs) (y:ys) = ((x+y) / 4) : elementSum xs ys --hihi

zip3' :: [(a,b)] -> [c] -> [d] -> [(a, b, c, d)]
zip3' [] y z = []
zip3' x [] z = []
zip3' x y [] = []
zip3' ((a,b):xs) (y:ys) (z:zs) = (a, b, y, z) : zip3' xs ys zs

b6_rawscenes :: [RawScene]
b6_rawscenes = map paketoi $ addTimeAndPos nicks
  where
    paketoi (name, scale, time, pos) = LoadNick name scale pos time
