{-# LANGUAGE ForeignFunctionInterface #-}

module TextGen where

import Foreign
import Foreign.C

#include "texture_generate.h"



data Image = Image { idata::Ptr CUChar, width::CInt, height::CInt, stride::CInt }

instance Storable Image where
  alignment _ = alignment(undefined :: Ptr ())
  sizeOf _ = #{size image_t}
  peek ptr = do
    idata <- #{peek image_t, idata} ptr
    width <- #{peek image_t, width} ptr
    height <- #{peek image_t, height} ptr
    stride <- #{peek image_t, stride} ptr
    return (Image idata width height stride)
  poke ptr (Image idata width height stride) = do
    #{poke image_t, idata} ptr idata
    #{poke image_t, width} ptr width
    #{poke image_t, height} ptr height
    #{poke image_t, stride} ptr stride

foreign import ccall "texture_generate.h create_text_image" createTextImage :: 
    CString -> CString -> IO (Ptr Image)


