local lastr, lastg, lastb
local effu_start2
local once = 1
local cre_number
local herb_number
local last = 0
local switch = 0
local hf_curstop = {0.6, 0.8, 1, 0.7, 0.65, 0.68, 0.73, 0.895, 0.73, 0.63, 0.78  }
local hypois = 0
local hypois_millis = 0
local nocursor = 0
-- this is done only once, when the demo starts
function credits_load() 
	cre_number2 = memarray('uchar', 1)
	glGenTextures(1, cre_number2:ptr())
	cre_number = cre_number2[0]
	glBindTexture(GL_TEXTURE_2D, cre_number)
	cre_ppm, cre_width, cre_height = load_texture('credits3.png')
		glTexImage2D(GL_TEXTURE_2D, 0, 3, cre_width, cre_height, 0, GL_RGB, GL_UNSIGNED_BYTE, cre_ppm:ptr())
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)

	herb_number2 = memarray('uchar', 1)
	glGenTextures(1, herb_number2:ptr())
	herb_number = herb_number2[0]
	glBindTexture(GL_TEXTURE_2D, herb_number)

	herb_ppm, herb_width, herb_height = load_texture('herb2.png')
		glTexImage2D(GL_TEXTURE_2D, 0, 3, herb_width, herb_height, 0, GL_RGB, GL_UNSIGNED_BYTE, herb_ppm:ptr())
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)
	once = 1
end

-- done just before first _paint
function credits_init(millis)
	--print("credits_init "..millis)

	if millis < 98000 then 
		rotobeat = 0
		effu_start = millis
	elseif millis > 100000 and millis < 110000 then
		effu_start = millis
	end

	hypois_millis = millis
	hypois = 0
end

local function set_material()                                                                                                                
        glEnable(GL_LIGHT0)
        glLightfv(GL_LIGHT0, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
        glLightfv(GL_LIGHT0, GL_DIFFUSE, {1, 1, 1, 1})
        glLightfv(GL_LIGHT0, GL_POSITION, {0.0, 1.0, 0.0, 0.0})

        glEnable(GL_LIGHT1)
        glLightfv(GL_LIGHT1, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
        glLightfv(GL_LIGHT1, GL_DIFFUSE, {1, 1, 1, 1})
        glLightfv(GL_LIGHT1, GL_POSITION, {1.0, 0.0, 1.0, 0.0})

        glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE)
        glFrontFace(GL_CW)
end



-- millis = milliseconds in song
function credits_paint(millis, timedelta, params)
	spectrum = engine_spectrum()

	beat = 0
	local beatcount = 50
	for i = 100, 100+beatcount do
		beat = beat + spectrum[i]
	end

	beat = beat / beatcount

	if params.transition == 5 then
	glClearColor(1.0,1.0,1.0,1);
	else
	glClearColor(0.0,0.0,0.0,1);
	end
        glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)

	if params.delta then
                millis = time + params.delta
        end
		
		local width = glutGet(GLUT_WINDOW_WIDTH)
		local height = glutGet(GLUT_WINDOW_HEIGHT)


	

	local hf = 0

	if params.herb then
		hf = params.herb
		if params.herb == 12 then 
			hf = 11
			hypois = 1
		end
	end

	glPushMatrix()
	glEnable(GL_MULTISAMPLE)
		glLoadIdentity()
		glOrtho(0, glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT), -100, 100)
		glMatrixMode(GL_MODELVIEW)
--		glTranslated(0,2,3)
--		glScaled(0.2,0.2,0.2)

		local width = glutGet(GLUT_WINDOW_WIDTH)
		local height = glutGet(GLUT_WINDOW_HEIGHT)

		local colr = 0
		local colg = 0
		local colb = 0



		local wobble_max = 0
		local wobble = 0



	if params.transition == 1 then
		local ys = (millis-effu_start)*height/4500
		if ys > height+1 then ys = height+1 end
		f = 1-(millis-effu_start)/4500
		glColor3d(f,f,f)
		glBegin(GL_QUADS)
			glVertex2d(0,height)---ys)
			glVertex2d(width,height)---ys)
			glVertex2d(width,-1)
			glVertex2d(0,-1)
		glEnd()
	end

	glEnable(GL_BLEND)
	glEnable(GL_TEXTURE_2D)

	set_material()

        glEnable(GL_DEPTH_TEST)
        glEnable(GL_NORMALIZE)

		local colr = 0
		local colg = 0
		local colb = 0


		local wobble_max = 0
		local wobble = 0 
		if params.transition == 5 then
			wobble_max = width
			wobble = (millis-effu_start)*width/7000
			if wobble > wobble_max then wobble = wobble_max end
			colr = colr + (millis-effu_start)*0.0001
			colg = colg + (millis-effu_start)*0.0001
			colb = colb + (millis-effu_start)*0.0001
			lastr = colr
			lastg = colg
			lastb = colb
			last_end = effu_start
		elseif params.transition == 1 then
			wobble_max = width
			wobble = (millis-last_end)*width/7000
			if wobble > wobble_max then wobble = wobble_max end
			colr = colr + (millis-last_end)*0.0001
			colg = colg + (millis-last_end)*0.0001
			colb = colb + (millis-last_end)*0.0001
			lastr = colr
			lastg = colg
			lastb = colb
		elseif params.transition == 0 then
			wobble_max = 0
			wobble = (millis-effu_start)*width/7000
			if wobble < wobble_max then wobble = wobble_max end
			colr = 1
			colg = 1
			colb = 1
			-- if colg > 1 then colg = 1 end

		elseif params.transition == 6 then
			wobble_max = 0
			wobble = (millis-effu_start)*width/7000
			if wobble < wobble_max then wobble = wobble_max end
			colr = 1-(millis-115200)*0.00015
			colg = 1
			-- 0+(millis-effu_start)*0.00005
			colb = 1-(millis-115200)*0.00015
			if colg > 1 then colg = 1 end


		elseif params.transition == 3 then
			if once == 1 then 
				effu_start2 = millis
				once = 0
				lastr = lastr-(millis-effu_start)*0.00003
				lastb = lastb-(millis-effu_start)*0.00003
			end
			wobble_max = width
			wobble = (millis-effu_start2)*width/13000
			if wobble > wobble_max then wobble = wobble_max end
			colr = lastr-(millis-effu_start)*0.0003
			colg = lastg-(millis-effu_start2)*0.000063
			colb = lastb-(millis-effu_start)*0.0003
		end

		glBindTexture(GL_TEXTURE_2D, cre_number)
		glColor3d(colr,colg,colb,0.7+math.cos(millis*0.002)*0.2)
		glBlendFunc(GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR)
		for y = 0, 512, 3 do
		glBegin(GL_QUADS)
			local ty = y/512
			local x = 0
			local cy = 0
			if params.transition == 5 or params.transition == 1 then
			x = width/2*math.cos((wobble_max-wobble)*0.003*(y*math.cos(millis*0.0002)*(y*0.0002)))*((wobble_max-wobble)*0.001)
			cy = y*(height/512)+math.cos(x*0.002+millis*0.0025)*height/500+x*0.003*(wobble_max-wobble)*0.001
			else
			x = math.cos(millis*0.002+(wobble_max-wobble)*0.00001+(y*0.01))*(wobble_max-wobble)*2
			cy = y*(height/512)+math.cos(x*0.02+millis*0.0025)*height/50+x*0.3+(wobble_max-wobble)*0.1
			end
			local cys = math.abs(math.cos(millis*0.0002)*height/16)
			glTexCoord2d(0,0)
			glVertex2d(x,cy-cys)
			glTexCoord2d(1,0)
			glVertex2d(width-x,cy-cys)
			glTexCoord2d(1,ty)
			glVertex2d(width-x,cy+cys)
			glTexCoord2d(0,ty)
			glVertex2d(x,cy+cys)
		glEnd()
		end

	if hf > 0 then
		if hf > last then
			last = hf
			switch = millis
		end
		hxs = width/3
		hx = width/2-hxs/2
		hy = height/2
		hys = height/8
		hypois_y = 0
		earthfade = 0
		if hypois == 1 and nocursor == 0 then
			hypois_y = (millis-hypois_millis)*height/15000
			if hypois_y >= hys then 
				hypois_y = hys
				nocursor = 1
			end
		end

		if nocursor == 1 then
			earthfade = (millis-hypois_millis)*0.00025
		end

		z = 3
		slice = 1-((hf/11)*0.999)
		speed = 0.004
		hscale = 1.1
		vscale = 0.8
		v = millis - switch
		offset = math.min(v*speed, hf_curstop[hf])*hxs
		glDisable(GL_TEXTURE_2D)
		glColor3d(0,0,0)
		glBegin(GL_QUADS)
			glVertex3d(hx*hscale+offset, hy, z)
			glVertex3d(hx*hscale+hxs+offset, hy, z)
			glVertex3d(hx*hscale+hxs+offset, hy+hys,z)
			glVertex3d(hx*hscale+offset, hy+hys,z)
		glEnd()
		if nocursor == 0 then
			blink = ((millis%200)<100)
			if blink then
				glColor3d(0,1,0)
			else
				glColor3d(0,0,0)
			end
			glBegin(GL_QUADS)
				glVertex3d(hx+offset, hy, z)
				glVertex3d(hx*hscale+offset, hy, z)
				glVertex3d(hx*hscale+offset, hy+hys-hypois_y,z)
				glVertex3d(hx+offset, hy+hys-hypois_y,z)
			glEnd() 
		end
		glEnable(GL_TEXTURE_2D)
		glBindTexture(GL_TEXTURE_2D, herb_number)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER)
		glColor3d(0,1.7-earthfade,0)
		glBegin(GL_QUADS)
			glTexCoord2d(0,0+slice)
			glVertex3d(hx, hy, z)
			glTexCoord2d(1,0+slice)
			glVertex3d(hx+hxs, hy, z)
			glTexCoord2d(1,slice+0.082)
			glVertex3d(hx+hxs, hy+hys,z)
			glTexCoord2d(0,slice+0.082)
			glVertex3d(hx, hy+hys,z)
		glEnd()
	end


	glDisable(GL_MULTISAMPLE)
	glDisable(GL_BLEND)
	glDisable(GL_TEXTURE_2D)
	glDisable(GL_LIGHTING)
	glPopMatrix()
end

-- called after last _paint
function credits_deinit()
	--print("credits_deinit")
end

function credits_unload()
	--print("credits_unload")
end
