local seal_ppm, seal_width, seal_height
local seal_number
local film_ppm, film_width, film_height
local film_number
local ultra_ppm, ultra_width, ultra_height
local ultra_number

local man_ppm, man_width, man_height
local man_number
local man_y = 0
local ultra_x = 0
local ultra_y = 0

local effu_start = 0
local effu_start2 = 0
local last = 0
local boom = 0
-- this is done only once, when the demo starts
function seal_load()
	seal_num = memarray('uchar', 1)
	seal_ppm, seal_width, seal_height = load_texture('hermetic.png')
	glGenTextures(1, seal_num:ptr())
	seal_number = seal_num[0]
	glBindTexture(GL_TEXTURE_2D, seal_number)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, seal_width, seal_height, 0, GL_RGB, GL_UNSIGNED_BYTE, seal_ppm:ptr())
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)

	film_num = memarray('uchar', 1)
	film_ppm, film_width, film_height = load_texture('brain.png')
	glGenTextures(1, film_num:ptr())
	film_number = film_num[0]
	glBindTexture(GL_TEXTURE_2D, film_number)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, film_width, film_height, 0, GL_RGB, GL_UNSIGNED_BYTE, film_ppm:ptr())
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)
	
	ultra_num = memarray('uchar', 1)
	ultra_ppm, ultra_width, ultra_height = load_texture('mkultra.png')
	glGenTextures(1, ultra_num:ptr())
	ultra_number = ultra_num[0]
	glBindTexture(GL_TEXTURE_2D, ultra_number)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, ultra_width, ultra_height, 0, GL_RGB, GL_UNSIGNED_BYTE, ultra_ppm:ptr())
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)


	man_num = memarray('uchar', 1)
	man_ppm, man_width, man_height = load_texture('man.png')
	glGenTextures(1, man_num:ptr())
	man_number = man_num[0]
	glBindTexture(GL_TEXTURE_2D, man_number)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, man_width, man_height, 0, GL_RGB, GL_UNSIGNED_BYTE, man_ppm:ptr())
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)
	effu_start = millis
	boom = 0
	man_y = 0
end

local filmspeed_default = 700
local filmspeed = filmspeed_default
local filmcount = 0
local framenum = 0
stripspeed = 0.00001

-- done just before first _paint
function seal_init(millis)
	last = 0
	--print("seal_init "..millis)
	effu_start2 = millis
	effu_start = millis

end

local function set_material()                                                                                                                
        glEnable(GL_LIGHT0)
        glLightfv(GL_LIGHT0, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
        glLightfv(GL_LIGHT0, GL_DIFFUSE, {1, 1, 1, 1})
        glLightfv(GL_LIGHT0, GL_POSITION, {0.0, 1.0, 0.0, 0.0})

        glEnable(GL_LIGHT1)
        glLightfv(GL_LIGHT1, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
        glLightfv(GL_LIGHT1, GL_DIFFUSE, {1, 1, 1, 1})
        glLightfv(GL_LIGHT1, GL_POSITION, {1.0, 0.0, 1.0, 0.0})

        glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE)
        glFrontFace(GL_CW)
end

-- millis = milliseconds in song
function seal_paint(millis, timedelta, params)

	spectrum = engine_spectrum()

	beat = 0
	local beatcount = 50
	for i = 00, 150+beatcount do
		beat = beat + spectrum[i]
	end

	beat = beat / beatcount

	boom = boom + beat*800
	if boom < 0 then boom = 0 end
	
	glClearColor(0.0,0.0,0.0,1);
        glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)

	if params.delta then
                millis = time + params.delta
        end

	glPushMatrix()
	glEnable(GL_MULTISAMPLE)
		glLoadIdentity()
		glOrtho(0, glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT), -100, 100)
		glMatrixMode(GL_MODELVIEW)

		local width = glutGet(GLUT_WINDOW_WIDTH)
		local height = glutGet(GLUT_WINDOW_HEIGHT)

		glEnable(GL_BLEND)
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)

		glEnable(GL_TEXTURE_2D)

		set_material()
		local camf = 0
		local camf2 = 0
		if camf > 1 then camf = 1 end
		if params.transition then
			if params.transition == 1 then
				camf=1-(millis-effu_start2)*0.000095
				--size = height
				camf2 = (millis-effu_start)*0.0000055
			end
		else
			camf = (millis-effu_start)*0.000068
		size = (millis-effu_start)*width/16000
		end

		glPushMatrix()
		glBindTexture(GL_TEXTURE_2D, man_number)
		manc = 0.15+math.cos(millis*0.0006)*0.05
--		glColor3d(manc-camf2,manc-camf2,manc-camf2)
		glColor3d(camf/2, camf/2, camf/2)
		man_y = man_y - timedelta/30000
		man_x = math.cos(millis*0.0004)*0.05
		man_sy = 1/3
		glBegin(GL_QUADS)
			glTexCoord2d(man_x,1.1+man_y)
			glVertex2d(0,0)
			glTexCoord2d(man_x+1,1.1+man_y)
			glVertex2d(width,0)
			glTexCoord2d(man_x+1,1.1+man_y+man_sy)
			glVertex2d(width,height)
			glTexCoord2d(man_x,1.1+man_y+man_sy)
			glVertex2d(0,height)
		glEnd()
		glPopMatrix()


		fade = 600
		a_start = 0.8
		ultra_scale = 0.4
		if (millis - last > fade) then
			last = millis
			ultra_x = (math.random()*ultra_width)
			ultra_y = (math.random()*ultra_height)
			a = a_start*camf
		end

		
		glBlendFunc(GL_SRC_COLOR, GL_ONE_MINUS_SRC_ALPHA)
		glBindTexture(GL_TEXTURE_2D, ultra_number)
		glColor4d(a,a,a,0)
		a = a - timedelta/(fade/a_start)
		--fullscreen bg quad (=docs)
		glBegin(GL_QUADS)
		  --lower left
		  glTexCoord2d(ultra_x*ultra_scale, ultra_y*ultra_scale);
		  glVertex3d(0, 0, -3);
		  --upper left
		  glTexCoord2d(ultra_x*ultra_scale, (ultra_y+1)*ultra_scale);
		  glVertex3d(0, height, -3);
		  --upper right
		  glTexCoord2d((ultra_x+1)*ultra_scale, (ultra_y+1)*ultra_scale);
		  glVertex3d(width, height, -3);
		  --lower right
		  glTexCoord2d((ultra_x+1)*ultra_scale, ultra_y*ultra_scale);
		  glVertex3d(width, 0, -3);
		glEnd()	



		glBindTexture(GL_TEXTURE_2D, seal_number)
		glPushMatrix()
		glEnable(GL_BLEND);
		glBlendFunc(GL_ONE, GL_ONE);
		glColor4d(camf,camf,camf,1)
		glTranslated(width/2,height/2,0)
		glRotated(boom,0,0,1)
		if size > height then size = height end
		--seal
		glBegin(GL_QUADS)
			glTexCoord2d(0,0)
			glVertex3d(-size/2,-size/2,-3)
			glTexCoord2d(1,0)
			glVertex3d(size/2,-size/2,-3)
			glTexCoord2d(1,1)
			glVertex3d(size/2,size/2,-3)
			glTexCoord2d(0,1)
			glVertex3d(-size/2,size/2,-3)
		glEnd()

		glPopMatrix()
		glPushMatrix()
		glBindTexture(GL_TEXTURE_2D, film_number)



		filmcount = filmcount + timedelta
		filmmove = (filmcount/filmspeed)*width/5
		glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
		strippos = (3/4)*width
		stripsize = (1/5)*width
		strippos2 = width-strippos-stripsize
	
		stripspeed = stripspeed+timedelta/40000000
		offset = stripspeed*filmcount


		--film
		glBegin(GL_QUADS)
		  --lower left
		  glTexCoord2d(0,0+offset);
		  glVertex3d(strippos, 0, -3);
		  --upper left
		  glTexCoord2d(0, 1+offset);
		  glVertex3d(strippos, stripsize*16, -3);
		  --upper right
		  glTexCoord2d(1, 1+offset);
		  glVertex3d(strippos+stripsize, stripsize*16, -3);
		  --lower right
		  glTexCoord2d(1, 0+offset);
		  glVertex3d(strippos+stripsize, 0, -3);

		  --[[lower left
		  glTexCoord2d(0,0+offset+64/256);
		  glVertex3d(strippos2, 0, -3);
		  --upper left
		  glTexCoord2d(0, 1+offset+64/256);
		  glVertex3d(strippos2, stripsize*16, -3);
		  --upper right
		  glTexCoord2d(1, 1+offset+64/256);
		  glVertex3d(strippos2+stripsize, stripsize*16, -3);
		  --lower right
		  glTexCoord2d(1, 0+offset+64/256);
		  glVertex3d(strippos2+stripsize, 0, -3);
			]]
		glEnd()

		glDisable(GL_TEXTURE_2D)
		glDisable(GL_BLEND)

		glPopMatrix()
	glDisable(GL_MULTISAMPLE)
	glPopMatrix()
end

-- called after last _paint
function seal_deinit()
	--print("seal_deinit")
end

function seal_unload()
	--print("seal_unload")
end
