local tex_size = 512
local tex_data
local dots_number
local effu_start = 0
local effu_start2 = 0
local noi_number
local noidata
local noiseback = 0
-- this is done only once, when the demo starts
function dots_load() 
	tex_number2 = memarray('uchar', 1)
	glGenTextures(1, tex_number2:ptr())
	dots_number = tex_number2[0]
	glBindTexture(GL_TEXTURE_2D, dots_number)
	rotobeat = 0
	tex_data = memarray('uchar', tex_size * tex_size * 3)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, tex_size, tex_size, 0, GL_RGB, GL_UNSIGNED_BYTE, tex_data:ptr())
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_BLEND)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_BLEND)
	reset_millis = 1
	ppm_num = memarray('uchar', 1)
	glGenTextures(1, ppm_num:ptr())
	noi_number = ppm_num[0]
	noidata = memarray('uchar', 128*128)
end

local reset_millis

-- done just before first _paint
function dots_init(millis)
	--print("dots_init "..millis)
	effu_start = millis
end

local function set_material()                                                                                                                
        glEnable(GL_LIGHT0)
        glLightfv(GL_LIGHT0, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
        glLightfv(GL_LIGHT0, GL_DIFFUSE, {1, 1, 1, 1})
        glLightfv(GL_LIGHT0, GL_POSITION, {0.0, 1.0, 0.0, 0.0})

        glEnable(GL_LIGHT1)
        glLightfv(GL_LIGHT1, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
        glLightfv(GL_LIGHT1, GL_DIFFUSE, {1, 1, 1, 1})
        glLightfv(GL_LIGHT1, GL_POSITION, {1.0, 0.0, 1.0, 0.0})

        glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE)
        glFrontFace(GL_CW)
end

-- millis = milliseconds in song
function dots_paint(millis, timedelta, params)
	for y = 0, 127 do
		for x = 0, 127 do
			noidata[y*128+x] = math.random(0,32)*8
		end
	end
	glBindTexture(GL_TEXTURE_2D, noi_number)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, 64, 64, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, noidata:ptr())

	spectrum = engine_spectrum()

	beat = 0
	local beatcount = 50
	for i = 100, 100+beatcount do
		beat = beat + spectrum[i]
	end

	beat = beat / beatcount

	glClearColor(0.0,0.0,0.0,1);
        glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)

	if params.delta then
                millis = time + params.delta
        end

	if reset_millis == 1 then 
		effu_start2 = millis
		reset_millis = 0 
	end

	local do_transition = 0

	if params.transition then
		do_transition = params.transition
	end
	local transu = 0
	if do_transition == 1 then
		transu = -((millis-effu_start)*0.0002)
	end



	glPushMatrix()
	glEnable(GL_MULTISAMPLE)
		glViewport(0, 0, tex_size, tex_size)
		glOrtho(0, tex_size, 0, tex_size, -100, 100)
		glMatrixMode(GL_PROJECTION)
--		glTranslated(0,2,3)
--		glScaled(0.2,0.2,0.2)

		local width = tex_size
		local height = tex_size

		local count = 40
		local scaler = width/100+(width/200*(beat*300))
		rotobeat = rotobeat+beat*1000
		glTranslated(width/1.5-scaler*16+math.cos(millis*(math.sin(millis*0.0006)*0.00005))*width/50,height/2-scaler*8,-3+math.cos(millis*0.0004)*20)
		glRotated(45,1,1,0)
		glRotated(math.cos(millis*0.0001)*5,1,0,0)
		--glTranslated(math.sin(rotobeat*0.002)*width/100,0,math.cos(rotobeat*0.0001)*100)
		glRotated(math.cos(rotobeat*0.00006)*30,1,0,0)
		glRotated(math.sin(millis*0.00007)*360,1,0,0)
		glRotated(math.cos(millis*0.00005)*360,0,1,1)

		glEnable(GL_BLEND)
		glBlendFunc(GL_SRC_COLOR, GL_ONE_MINUS_DST_COLOR)
		glBegin(GL_TRIANGLES)
			for z = 0, 32, 2 do
				for y = 0, 32, 2 do
						col = (z+1)/32+math.cos(y*0.5+millis*0.001)*1
						col2 = (y+1)/64+math.sin(y*0.4+millis*0.001)*1
					glColor4d(transu*1.4+1-col*0.4,transu*1.6+1-col2,transu*1.5+1-col*0.5,1)
					for x = 0, 32, 2 do
						local vx = (x*math.cos(y*0.015+z*0.08+millis*0.003))*scaler
						local vy = (y*math.sin(x*0.012+z*0.07+millis*0.002))*scaler
						local vz = (z*math.cos(x*0.017+y*0.05+millis*0.001))*scaler
						glVertex3d(vx,vy,vz)
						glVertex3d(vx+((x+1)*scaler/2),vy,vz)
						glVertex3d(vx+((x+1)*scaler/2),vy+((y+1)*scaler/2),vz)
					end
				end
			end
		glEnd()
	glPopMatrix()
	glPushMatrix()
	glEnable(GL_TEXTURE_2D)
	glBindTexture(GL_TEXTURE_2D, dots_number)
	glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 0, 0, tex_size, tex_size, 0)
	glClearColor(0.0,0.0,0.0,1);
        glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)
	width = glutGet(GLUT_WINDOW_WIDTH)
	height = glutGet(GLUT_WINDOW_HEIGHT)
	glViewport(0, 0, width, height)
	glOrtho(0, width, 0, height, -100, 100)
	glMatrixMode(GL_MODELVIEW)

	glEnable(GL_TEXTURE_2D)
	glEnable(GL_BLEND)
	glBlendFunc(GL_ONE, GL_ONE)
	glBindTexture(GL_TEXTURE_2D, dots_number)
	
	glColor4d(1,1,1,1)
	glBegin(GL_QUADS)
		glTexCoord2d(0,0)
		glVertex2d(0,0)
		glTexCoord2d(1,0)
		glVertex2d(width,0)
		glTexCoord2d(1,1)
		glVertex2d(width,height)
		glTexCoord2d(0,1)
		glVertex2d(0,height)
	glEnd()

	glBlendFunc(GL_ONE, GL_SRC_ALPHA)

	xcount = 2+math.cos((millis-effu_start2)*0.0002)*2
	ycount = 2+math.cos((millis-effu_start2)*0.0004)*2
	for y = -2, ycount+4 do
		for x = -2, xcount*2 do
			r = transu+(0.5+math.cos(y*0.001+x*0.2*millis*0.0001)*0.3)
			g = transu+(0.6+math.sin(y*0.001*millis+x*0.0002)*0.5)
			b = transu+(0.6+math.cos(x*0.001+millis*0.0001)*0.5)
			glColor4d(r,g,b,1)
			sx = width/xcount
			sy = height/ycount
			tx = x*(width/xcount/2)+math.cos(millis*0.001)*sx/10
			ty = y*(height/ycount/2)+math.sin(millis*0.001)*sy/10
			z = x*y*0.1
			glBegin(GL_QUADS)
				glTexCoord2d(0,0)
				glVertex3d(tx,ty,z)
				glTexCoord2d(1,0)
				glVertex3d(tx+sx,ty,z)
				glTexCoord2d(1,1)
				glVertex3d(tx+sx,ty+sy,z)
				glTexCoord2d(0,1)
				glVertex3d(tx,ty+sy,z)
			glEnd()
		end
	end

		kohpois = (1)-(millis-effu_start)*0.0002
		if kohpois > 0 then
		glEnable(GL_BLEND)

		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
		glColor4d(1,1,1,kohpois-noiseback)

		glEnable(GL_TEXTURE_2D)
		glBindTexture(GL_TEXTURE_2D, noi_number)
		tx = 6-(-1+kohpois)*4
		ty = 4

		glBegin(GL_QUADS)
			glTexCoord2d(0,0)
			glVertex2d(0,0)
			glTexCoord2d(tx, 0)
			glVertex2d(width,0)
			glTexCoord2d(tx, ty)
			glVertex2d(width, height)
			glTexCoord2d(0, ty)
			glVertex2d(0, height)
		glEnd()
		else
			noiseback = 0.2
		end
	
	glDisable(GL_MULTISAMPLE)
	glPopMatrix()
end

-- called after last _paint
function dots_deinit()
	--print("dots_deinit")
end

function dots_unload()
	--print("dots_unload")
end
