local once = 1

-- this is done only once, when the demo starts
function rewind_load() 
	bilogony_number2 = memarray('uchar', 1)
	glGenTextures(1, bilogony_number2:ptr())
	bilogony_number = bilogony_number2[0]
	glBindTexture(GL_TEXTURE_2D, bilogony_number)
	bilogony_ppm, bilogony_width, bilogony_height = load_texture('bilogon.png')
		glTexImage2D(GL_TEXTURE_2D, 0, 3, bilogony_width, bilogony_height, 1, GL_RGB, GL_UNSIGNED_BYTE, bilogony_ppm:ptr())
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)
	
	once = 1
end

-- done just before first _paint
function rewind_init(millis)
end

-- millis = milliseconds in song
function rewind_paint(millis, timedelta, params)
	if params.transition then
		glPushMatrix()
		glClearColor(1,1,1,1)
        	glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)
		glEnable(GL_MULTISAMPLE)
		glEnable(GL_TEXTURE_2D)
			glLoadIdentity()
			glTranslated(0,0,0)
			glOrtho(0, glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT), -100, 100)
			glMatrixMode(GL_MODELVIEW)
			local width = glutGet(GLUT_WINDOW_WIDTH)
			local height = glutGet(GLUT_WINDOW_HEIGHT)

			glColor3d(1,1,1,1)
			glBindTexture(GL_TEXTURE_2D, bilogony_number)
			glBegin(GL_QUADS)
			local wm = (width-(width/2))/2
			local wp = (width+(width/2))/2
			local hm = (height-(height/3))/8+(height/8)
			local hp = (height+(height/3))/2+(height/8)
			glTexCoord2d(0,0)
			glVertex2d(wm,hm)
			glTexCoord2d(1,0)
			glVertex2d(wp,hm)
			glTexCoord2d(1,1)
			glVertex2d(wp,hp)
			glTexCoord2d(0,1)
			glVertex2d(wm,hp)

			glEnd()

			glPopMatrix()
		glDisable(GL_MULTISAMPLE)
		glDisable(GL_TEXTURE_2D)
		glPopMatrix()
	end
end

-- called after last _paint
function rewind_deinit()
	--print("rewind_deinit")
end

function rewind_unload()
	--print("rewind_unload")
end
