EffectSceneAbstractMore = Effect:new({num = 200, r = 1, g = 1, b = 1, alpha_max = 0.9})

function EffectSceneAbstractMore:setup()
	self.alpha = 0 -- self.alpha_max
	self.w = width()
	self.h = height()
	self.x = -0.5 * width()
	self.y = -0.5 * height()
	self.rotation_sign = 3
	self.start_index = 1
	self.point_size = 1
	self.time_multiplier = 1
	self.current_image = -1
	
	self.points = {}
	local s = 200
	for i = 1, self.num, 1 do
		t = math.pi * i * math.random() * 4
		table.insert(self.points, {
			--[[x = s * (0.5 - math.random()),
			y = s * (0.5 - math.random()),
			z = s * (0.5 - math.random())]]--
			x = s * math.sin(t*t),
			y = s * math.cos(-t) * math.sin(-t),
			z = s * math.cos(t)
		})
	end
	
	self.camera = { x = 100, y = 0, z = 100, look_x = 0, look_y = 0, look_z = 0, up_x = 0, up_y = 1, up_z = 0, fov = 60, aspect_ratio = width() * 1.0 / height() }
end

function EffectSceneAbstractMore:update (time)
	local elapsed = time - self.lastTimeUpdated
	local cam = self.camera
	
	local r = 100
	
	self.alpha = self.alpha - elapsed
	if self.alpha < 0 then
		self.alpha = 0
	end	
	
	--[[local t = self.rotation_sign * time
	cam.x = r * math.sin(t)
	cam.z = r * math.cos(t)
	cam.y = 100 --r * math.sin(time)]]--
	
	t = time * self.rotation_sign * self.time_multiplier
	cam.x = r * math.sin(t)
	cam.z = r * math.cos(t)
	cam.y = r * math.sin(t * 0.5) * math.cos(t * 0.25)
	
	
	camera(
		cam.x, cam.y, cam.z,
		cam.look_x, cam.look_y, cam.look_z,
		cam.up_x, cam.up_y, cam.up_z
	)
	perspective(cam.fov, cam.aspect_ratio, 1, 1000)	
	
	blending(BLENDING_ALPHABLEND)
	--rectangle(self.x, self.y, self.w, self.h)
	
	--drawAxis()
	
	color(self.r, self.g, self.b, self.alpha)
	--pointSize(4 * self.alpha)
	pointSize(self.point_size)
	beginShape(SHAPE_POINTS)
	for i = 1, self.num, 1 do
		local p = self.points[i]
		vertex(p.x, p.y, p.z)
	end
	endShape()
	
	color(self.r, self.g, self.b, self.alpha * 0.45)
	beginShape(SHAPE_LINES)
	--[[for i = self.start_index, self.num - self.step, 1 do
		
		local p = self.points[i]
		local q = self.points[i + self.step]
		
		line(p.x, p.y, p.z,
			q.x, q.y, q.z)
	end]]--
	
	for i = 1, self.num - 1, 1 do
		local p = self.points[i]
		local q = self.points[i + 1]
		
		if q ~= nil then
			vertex(p.x, p.y, p.z)
			vertex(q.x, q.y, q.z)
		end
	end
	
	
	endShape()
	
	--noBlending()

	restoreProjection()
	
	ortho()--ortho(width()*2, height()*2)
	--[[color(0, 1, 0, 0.5)
	blending(BLENDING_INVERTDEST)
	rectangle(self.x, self.y, self.w, self.h)
	noBlending()]]--
	--blending(BLENDING_ALPHABLEND)
	local a = 0.95
	color(a, a, a, 1 - self.alpha)
	
	if self.current_image == 0 then
		image(img_xplsv, -0.5, -0.5, width(), height())
	elseif self.current_image == 1 then
		image(img_totally, -0.5, -0.5, width(), height())
	elseif self.current_image == 2 then
		image(img_yay, -0.5, -0.5, width(), height())
	elseif self.current_image == 3 then
		image(img_greetings, -0.5, -0.5, width(), height())
	end
	restoreProjection()
	

	Effect.update(self, time)	
end

function EffectSceneAbstractMore:processEvent(event)
	--[[if event.type == EVENT_CHANGE_ROW then
		self.point_size = event.row % 8
	elseif event.type == EVENT_CHANGE_ORDER then
		self.rotation_sign = self.rotation_sign * -1
		self.r = math.random() + 0.5
		self.g = math.random() + 0.5
		self.b = math.random() + 0.5
		
		if event.order_position == 8 then
			self.time_multiplier = 2.5
		end
	elseif event.type == EVENT_NOTE_ON then
		-- listen to bassdrum
		if event.instrument == 1 then
			self.alpha = self.alpha_max
			self.camera.look_y = self.rotation_sign
		end
	end]]--
	
	if event.type == EVENT_NOTE_ON then
		-- listen to bassdrum
		if event.instrument == 1 then
			self.alpha = self.alpha_max
			self.camera.look_y = self.rotation_sign
			
			self.rotation_sign = self.rotation_sign * -1
			self.r = math.random() + 0.5
			self.g = math.random() + 0.5
			self.b = math.random() + 0.5
			

		end
	elseif event.type == EVENT_CHANGE_ROW then
		if event.row % 32 == 0 then
			self.current_image = (self.current_image + 1) % 4
		end
	end
end
