
EffectSequencer = { effects = {}, current_order = 0, current_row = 0 }
function EffectSequencer.add(effect, params)
	start_order = params.start_order or 0
	start_row = params.start_row or 0
	end_order = params.end_order or 1000
	end_row = params.end_row or 0
	label = params.label or 'Effect ' .. #EffectSequencer.effects
	
	table.insert(EffectSequencer.effects, { 
		effect = effect,
		start_order = start_order,
		start_row = start_row,
		end_order = end_order,
		end_row = end_row,
		label = label 
	} )
end

function EffectSequencer.setupEffects()
	for index, entry in pairs(EffectSequencer.effects) do
		entry.effect:setup()
	end
end

function EffectSequencer.dump()
	print("EffectSequencer - effects dump")
	print('------------------------------')
	for index, entry in pairs(EffectSequencer.effects) do
		print(index, entry.label, 'start', entry.start_order, entry.start_row, 'end', entry.end_order, entry.end_row)
	end
end

function EffectSequencer.update(time)
	for index, entry in pairs(EffectSequencer.effects) do
		local order = EffectSequencer.current_order
		local row = EffectSequencer.current_row
		
		if (
			( (order == entry.start_order and row >= entry.start_row) or (order > entry.start_order) ) and
			( (order == entry.end_order and row < entry.end_row ) or (order < entry.end_order) )
		)
		then
			entry.effect:update(time)
		end
		
		
	end
end

function EffectSequencer.getActiveEffects()
	local active = {}
	for index, entry in pairs(EffectSequencer.effects) do
		if entry.effect.visible then
			table.insert(active, entry.effect)
		end
	end
	return active
end

-- self is kind of tricky: ignored because this isn't an instance
-- but neccessary due to the way the EventDispatcher works
-- (expects instances of objects)
function EffectSequencer.processEvent(self, event)
	if event.type == EVENT_CHANGE_ORDER then
		trace("seq ord = " .. event.order_position .. " | " .. event.timestamp .. ' pat ' .. event.pattern)
		EffectSequencer.current_order = event.order_position
	elseif event.type == EVENT_CHANGE_ROW then
		EffectSequencer.current_row = event.row
	end
	
	--trace('effectSequencer process event, order = ' .. EffectSequencer.current_order .. ' row ' .. EffectSequencer.current_row)

end
