/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "antheap.h"
#include <sstream>

using sf::operator+;

ant_heap::ant_heap(animation_loader *l) : 
	selectable(l?&l->get_animation("ant_heap"):0), cur_spawned(0), cur_time(0), 
	spawned_waves(0)
{
	set_w(64);
	set_h(64);
	set_mode("stand");

	ant_waves.push_back(ant_wave(1, 1, 1, 35.0f, 35.0f));
	ant_waves.push_back(ant_wave(1, 2, 1, 20.0f, 35.0f));
	ant_waves.push_back(ant_wave(3, 3, 2, 20.0f, 60.0f));
	ant_waves.push_back(ant_wave(2, 3, 4, 20.0f, 60.0f));
	ant_waves.push_back(ant_wave(2, 4, 6, 20.0f, 60.0f));
	ant_waves.push_back(ant_wave(2, 5, 7, 20.0f, 60.0f));
	ant_waves.push_back(ant_wave(2, 6, 8, 20.0f, 60.0f));
	ant_waves.push_back(ant_wave(2, 6, 10, 20.0f, 60.0f));
	ant_waves.push_back(ant_wave(2, 6, 11, 20.0f, 60.0f));
	ant_waves.push_back(ant_wave(2, 6, 12, 20.0f, 60.0f));

	next_wave = ant_waves.begin();
	cur_wave = ant_waves.end();
}

void ant_heap::update(world &w)
{
	object::update(w);
	std::vector<ant*> &ants = w.get_ants();
	cur_time += DT;
	last_spawn += DT;
	if(cur_time >= next_wave->max_time ||
		(cur_time >= next_wave->min_time && ants.size() == 0)) {
		cur_wave = next_wave;
		cur_time = 0;
		cur_spawned = 0;
		if(cur_wave != ant_waves.end()) {
			cur_wave->times--;
			if(cur_wave->times <= 0)
				next_wave++;
			if(next_wave == ant_waves.end())
				next_wave--;
		}
		spawned_waves++;
	}
	if(cur_wave != ant_waves.end()) {
		for(int y = -1; y <= 1; y++) {
			for(int x = -1; x <= 1; x++) {
				if(cur_spawned == cur_wave->ants)
					continue;
				if((x == 0 && y == 0) || 
								(x == 1 && y == 0))
					continue;

				ant *a = new ant(w.anim_loader, cur_wave->ant_levels);
				a->set_pos(get_pos() + sf::Vector2f((52+2*cur_wave->ant_levels) * x + 16,
										(52+2*cur_wave->ant_levels) * y + 16));
				if(w.collision(*a)) {
					delete a;
				} else {
					ants.push_back(a);
					w.add_obj(a);

					cur_spawned++;
				}
			}
		}
	}
}

std::string ant_heap::wave_string()
{
	std::stringstream ss(std::stringstream::out);
	ss << spawned_waves << " waves spawned";
	return ss.str();
}
std::string ant_heap::level_string()
{
	std::stringstream ss(std::stringstream::out);
	ss << "Next levels: "<< next_wave->ant_levels;
	return ss.str();
}
std::string ant_heap::how_many_string()
{
	std::stringstream ss(std::stringstream::out);
	if(next_wave->ants == 1)
		ss << "How many: "<< next_wave->ants << " ant";
	else
		ss << "How many: "<< next_wave->ants << " ants";
	return ss.str();
}

std::string ant_heap::min_time_string()
{
	std::stringstream ss(std::stringstream::out);
	ss.setf(std::ios::fixed, std::ios::floatfield);
	ss.precision(1);
	if(next_wave->min_time - cur_time <=0)
		ss << "min time left: 0";
	else
		ss << "min time left: " << next_wave->min_time - cur_time;
	return ss.str();
}

std::string ant_heap::max_time_string()
{
	std::stringstream ss(std::stringstream::out);
	ss.setf(std::ios::fixed, std::ios::floatfield);
	ss.precision(1);
	ss << "max time left: " << next_wave->max_time - cur_time;
	return ss.str();
}
