/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "commandcenter.h"
#include "world.h"
#ifndef NO_GRAPHICS
#include "gui.h"
#endif

command_center::command_center(animation_loader *l) : selectable(l?&l->get_animation("command_center"):0),
	mushrooms_growd(1)
{
	set_mode("stand");
	set_h(64);
	set_w(64);
	
	set_max_energy(1000);
	add_energy(50);

	spells.push_back(spell(spell::cc_grow_mushroom));
	spells.push_back(spell(spell::cc_connect));
	spells.push_back(spell(spell::cc_fertilize_str));
	spells.push_back(spell(spell::cc_fertilize_mana));
	spells.push_back(spell(spell::cc_fertilize_dur));
	calc_spell_ids();
	hp = max_hp = 100.0f;
}


#ifndef NO_GRAPHICS
void command_center::draw(sf::RenderTarget &target)
{
	object::draw(target);

	double up_bar = get_hp() / get_max_hp();
	
	Gui::drawFilledRectangle(target, Gui::Rect(get_x(), get_y() - 10, get_w(), 3), up_bar, sf::Color::Red);
	Gui::drawFilledRectangle(target, Gui::Rect(get_x(), get_y() - 5, get_w(), 3), get_energy() / get_max_energy(), sf::Color::Blue);

	//Gui::drawFilledRectangle(target, Gui::Rect(get_x(), get_y() - 5, get_w(), 3), up_bar, sf::Color::Red);
}
#endif

void command_center::disconnect_mushroom(mushroom *m)
{
	std::list<mushroom*>::iterator it;
	for(it = connected_mushrooms.begin(); it != connected_mushrooms.end(); it++)
	{
		if((*it) == m)
		{
			connected_mushrooms.erase(it);
			return;
		}
	}
}

void command_center::tree_fix(world &w)
{
	std::list<mushroom*> new_tree;
	std::list<mushroom*> access = connected_mushrooms;
	w.set_cc_tree_visited();

	std::list<mushroom*>::iterator it;
	for(it = access.begin(); it != access.end(); it++)
		(*it)->cc_tree_visited = true;

	while(!access.empty()) {
		mushroom *m = access.front();
		access.pop_front();

		std::list<mushroom*>::iterator it2;
		for(it2 = tree.begin(); it2 != tree.end(); it2++) {
			if(m == (*it2)) {
				new_tree.push_back(m);
				std::list<mushroom*>::iterator it3;
				for(it3 = m->get_connections().begin(); it3 != m->get_connections().end(); it3++){
					if((*it3)->cc_tree_visited == false) {
						(*it3)->cc_tree_visited = true;
						access.push_back(*it3);
					}
				}
			}
		}
	}
	tree = new_tree;
}

bool command_center::win(world &w)
{
	return win_connected(NULL, w);
}

bool command_center::win_connected(mushroom *m_near_goal, world &w)
{
	std::list<mushroom*> access = connected_mushrooms;
	w.set_cc_tree_visited();

	std::list<mushroom*>::iterator it;
	for(it = access.begin(); it != access.end(); it++)
		(*it)->cc_tree_visited = true;

	while(!access.empty()) {
		mushroom *m = access.front();
		access.pop_front();

		if(m_near_goal == NULL && w.get_map().near_goal(m, GOAL_WIN_RANGE))
			return true;
		if(m == m_near_goal)
			return true;

		std::list<mushroom*>::iterator it2;
		for(it2 = m->get_connections().begin(); it2 != m->get_connections().end(); it2++){
			if((*it2)->cc_tree_visited == false) {
				(*it2)->cc_tree_visited = true;
				access.push_back(*it2);
			}
		}
	}
	return false;
}

void command_center::tree_add(mushroom *m, world &w)
{
	tree.push_back(m);
	tree_fix(w);
}

bool command_center::tree_rm(mushroom *m)
{
	std::list<mushroom*>::iterator it;
	for(it = tree.begin(); it != tree.end(); it++) {
		if((*it) == m) {
			tree.erase(it);
			return true;
		}
	}	
	return false;
}

void command_center::tree_add_rm(mushroom *m, world &w)
{
	if(!tree_rm(m))
	{
		tree_add(m, w);
	}
}

bool command_center::is_connected(mushroom *m)
{
	std::list<mushroom*>::iterator it;
	for(it = connected_mushrooms.begin(); it != connected_mushrooms.end(); it++) {
		if(*it == m) {
			return true;
		}
	}	
	return false;
}
void command_center::connect_mushroom(mushroom *m)
{
	if(!is_connected(m))
	   	connected_mushrooms.push_back(m);
}

