/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*    Santtu Keskinen <laquendi@gmail.com>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _CREATURE_H
#define _CREATURE_H

#include "object.h"
#include "pauseclock.h"
#include "animationloader.h"
#include "spell.h"
#include "selectable.h"
#include "moving.h"
#include <vector>
#include <map>
#include <string>

class world;

class creature : public selectable, public moving {
	public:
		enum creature_type
		{
			unicorn,
			minotaur,
			griffin
		};

		creature(animation_loader *l, creature_type c_type);
		~creature();

		void update(world &w);
		
		void gain_exp(world &w, int d_exp);
		int get_exp() { return exp; }
		int get_level() { return level; }
		bool is_max_level() { return level==max_level; }
		int get_req_exp();
		int get_prev_level_exp();
		float get_level_progress();
		void ding();
		void down_ding();
		bool has_moved() { return moved; }
		void stop_moving() { set_move_pos(get_center()); }
		
		void set_move_pos(sf::Vector2f mv);
		void move_towards_cast_target(spell &casted_spell, sf::Vector2f mv);
		
		int *get_mushroom_attribs() { return &mushroom_attr_table[(level - 1) * 3]; }

		bool moving_to_target;
		spell dummy_spell;
		spell &spell_to_cast;
		sf::Vector2f spell_target_pos;

		void boost_stats(int boost);

		creature_type get_type() const { return t; };

		bool collision(const object &obj) const;
		static const char *names[];
	private:
		
		bool moved;
		const creature_type t;
		int exp;
		int level;
		static const int max_level;
		static const int exp_table[3][3];
		static const int base_mushroom_attr_table[3][4][3];
		int *mushroom_attr_table;
};

#endif

