/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _GAME_H
#define _GAME_H

#include <iostream>
#include <SFML/Network.hpp>
#include "gui.h"
#include "animationloader.h"
#include "world.h"
#include "mushroom.h"
#include "pauseclock.h"
#include "spell.h"
#include "settings.h"
#include "sbox.h"
#include "event.h"
#include "pauseclock_rt.h"
#include "record.h"
#include "spellhotkey.h"
#include "spell_emitter.h"
#include "soundplayer.h"
#include "musicplayer.h"
#include "config.h"
#include "volumewidget.h"
#include "popup.h"

class game : public Gui::ActionListener, public event_handler {
	public:
		game(creature::creature_type, soundplayer &sp, musicplayer &mp, 
				bool rep = false, record r = record());
		~game();

		Gui::Container *window;

		animation_loader anim_loader;
		world g_world;

		soundplayer &sound_player;
		musicplayer &music_player;

		bool quit() { return quit_pressed; }
		bool is_paused() { return paused; }


		void draw(sf::RenderTarget &);
		bool update();

		void send_replay();

		void draw_ghost_mushroom(sf::RenderTarget &);
		void draw_ghost_cc(sf::RenderTarget &);
		void draw_ghost_trap(sf::RenderTarget &);

		// events
		virtual void ButtonClick(Gui::ID srcid);
		virtual void MouseClick(Gui::ID srcid, int x, int y, Gui::MouseButton m);
		virtual void KeyDownAction(sf::Event::KeyEvent k);

		virtual void hit(object *src, object *target, attack &atk);
		virtual void grow(mushroom *, mushroom::mushroom_type);
		virtual void near_grow(mushroom *, mushroom::mushroom_type);
		virtual void die(object *obj);
		virtual void spawn(object *obj);
		virtual void ding(object *obj);
		virtual void win();
		virtual void lose();
		virtual void wind_blow();
		virtual void wind_stop();
		virtual void trap_trigger(trap *, ant *a);
		virtual void cast_spell(object *caster, const spell &sp);

		static void set_button(Gui::Button *);
		std::string rep_file();
	private:
		Gui::Container *sidebar;
		Gui::ImgButton *menu_button;
		
		Gui::TextLabel *level_label;
		Gui::TextLabel *exp_label;
		Gui::Bar *exp_bar;
		Gui::Image *main_char_image;
		volume_widget *sound_vol;
		volume_widget *music_vol;

		sf::Image sidebar_img;
		sf::Image menu_img;
		sf::Image vol_up, vol_down;

		sbox *selected_box;

		std::vector<selectable*> num_key_selections;

		Gui::Container *draw_area;
		
		// menu 
		Gui::Container *menu;
		Gui::Button *continue_button;
		Gui::Button *quit_button;

		// popup dialog
		popup *popup_win;

		void update_level_labels();

		record rec;

		pclock_realtime game_clock;
		pclock game_time;
		int frame_count;

		bool replay_mode;

		bool paused;
		bool quit_pressed;

		particle_engine p_engine;

		void cancel_casting();
		void run_replay();

		void upload_record();
		void encode_request_data(std::string &body, const std::string &boundary, 
				const std::string &name, const std::string &data, 
				const std::string &filename = "");

		enum click_mode {
			cast_spell_mode,
			select_mode
		} cur_mode;
		spell cur_spell;
		mushroom ghost_mushroom;
		command_center ghost_cc;

		sf::Image logo;

		spell_hotkey_handler spell_hotkey;
};

#endif
