/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include <algorithm>
#include "mainmenu.h"
#include "settings.h"

main_menu::main_menu() :
	quit_pressed(false), start_pressed(false), select_replay(false)
{
	window = new Gui::Container(Gui::Rect(0, 0, SCREEN_W, SCREEN_H));
	window->SetActionListener(this);

	Gui::TextLabel *versionlabel = new Gui::TextLabel(Gui::Coor(1150, 700), version_strings[VERSION]);
	versionlabel->SetSize(20);
	versionlabel->SetFontColor(sf::Color(20, 30, 100));
	window->Add(versionlabel);

	smenu = new settings_menu(Gui::Rect(0, 0, SCREEN_W, SCREEN_H));
	smenu->Hide();
	window->Add(smenu);

	button_list = new Gui::VerticalList(Gui::Rect(0, 20, 355, 600), 30);
	start_button = new Gui::Button("Start");
	replay_button = new Gui::Button("Replay");
	hiscores_button = new Gui::Button("Online highscores");
	page_button = new Gui::Button("Online tutorial");
	settings_button = new Gui::Button("Settings");
	quit_button = new Gui::Button("Quit");

	select.LoadFromFile("gfx/select.png");
	mythorb_logo.LoadFromFile("gfx/mythorb_logo.png");
	logo.LoadFromFile("gfx/logo.png");

	window->Add(new Gui::Image(mythorb_logo, Gui::Rect(20, 550, 256, 128)));

	button_list->AddCenter(new Gui::Image(logo));
	button_list->AddCenter(new Gui::Object(Gui::Rect(0, 0, 0, 20)));
	Gui::Button* buttons[6] = {start_button, replay_button, page_button, hiscores_button,
		settings_button, quit_button};
	for(int i = 0; i < 6; i++) {
		set_button(buttons[i]);
		button_list->AddCenter(buttons[i]);
	}

	replay_window = new Gui::Container(Gui::Rect(0, 0, SCREEN_W, SCREEN_H));
	replay_window->Hide();

	// replay menu
	{
		const int left = 450;
		Gui::TextLabel *replay_label = new Gui::TextLabel(Gui::Rect(left, 200, 400, 80), "Select replay");
		replay_label->SetFontColor(sf::Color(0x40, 0x80, 0x80));
		replay_list = new Gui::TextSelection(Gui::Rect(left, 250, 450, 300), select, replay_files);
		replay_list->DrawBG(true);
		replay_list->SetColor(sf::Color(0, 0x25, 0x25));
		replay_list->SetFontColor(sf::Color(0, 0x50, 0));
		replay_list->SetBorderColor(sf::Color(0, 0x80, 0x80));

		Gui::HorizontalList *rp_buttons = new Gui::HorizontalList(Gui::Rect(left, 600, 300, 60));
		back_to_menu = new Gui::Button("Back to menu");
		set_button(back_to_menu);
		play_replay = new Gui::Button("Play");
		set_button(play_replay);

		rp_buttons->Add(back_to_menu)->
			Add(play_replay);

		replay_window->Add(replay_label)->
			Add(replay_list)->
			Add(rp_buttons);

	}
	window->Add(replay_window);


	// game start menu
	game_select_window = new Gui::Container(Gui::Rect(0, 0, SCREEN_W, SCREEN_H));
	game_select_window->Hide();
	{
		unicorn = new Gui::Button("Unicorn");
		set_button(unicorn);
		unicorn->Expand(5, 5);
		minotaur = new Gui::Button("Minotaur");
		set_button(minotaur);
		minotaur->Expand(5, 5);
		griffin = new Gui::Button("Griffin");
		set_button(griffin);
		griffin->Expand(5, 5);

		Gui::TextLabel *game_label = new Gui::TextLabel(Gui::Rect(500, 200, 400, 80),
				"Select character");
		game_label->SetFontColor(sf::Color(0x40, 0x80, 0x80));

		Gui::VerticalList *game_vert = new Gui::VerticalList(Gui::Rect(200, 350, 500, 200));

		Gui::HorizontalList *game_buttons = new Gui::HorizontalList(Gui::Rect(0, 0, 500, 0));
		game_buttons->Add(unicorn)->
			Add(minotaur)->
			Add(griffin);

		back_to_menu1 = new Gui::Button("Back to menu");
		set_button(back_to_menu1);

		game_vert->Add(game_buttons)->
			AddCenter(back_to_menu1);

		game_select_window->Add(game_label)->
			AddCenter(game_vert);
	}

	window->Add(game_select_window);

	button_list->Zip();
	window->AddCenter(button_list);

	bg.LoadFromFile("gfx/background.png");
	window->Add(new Gui::Image(bg,  window->GetRect()));
}

main_menu::~main_menu()
{
	delete window;
}

void main_menu::set_button(Gui::Button *b)
{
	b->Expand(30, 10);
	b->DrawBG(true);
	b->SetHilightUnderMouse(true);
	b->SetColor(sf::Color(0, 0x25, 0x25));
	b->SetBorderColor(sf::Color(0, 0x50, 0));
	b->SetFontColor(sf::Color(0, 0x50, 0x50));
}

bool main_menu::start_game()
{
	if(start_pressed) {
		start_pressed = false;
		return true;
	} else {
		return false;
	}
}

std::string main_menu::replay()
{
	if(select_replay) {
		int selected = replay_list->GetSelected();
		if(selected >= 0) {
			select_replay = false;
			show_menu();
			return replay_files[selected];
		}
	}

	return "";
}

void main_menu::hide_menu()
{
	button_list->Hide();
}

void main_menu::show_menu()
{
	button_list->Show();
	replay_window->Hide();
	game_select_window->Hide();
}

void main_menu::ButtonClick(Gui::ID srcid)
{
	if(srcid == start_button->GetID()) {
		game_select_window->Show();
		button_list->Hide();
	} else if(srcid == quit_button->GetID()) {
		quit_pressed = true;
	} else if(srcid == replay_button->GetID()) {
		hide_menu();
		replay_window->Show();
		replay_files.clear();
		list_dir("replays", replay_files);
		std::sort(replay_files.begin(), replay_files.end());
		replay_list->SetText(replay_files);
		replay_list->Focus();
		replay_window->Focus();
	} else if(srcid == page_button->GetID()) {
		open_page("http://ds.kapsi.fi/view/Beginner%27s_Page");
	} else if(srcid == hiscores_button->GetID()) {
		open_page("http://ds.kapsi.fi/scoreboard");
	} else if(srcid == settings_button->GetID()) {
		hide_menu();
		smenu->Raise();
		smenu->Show();
		window->SetFocus(smenu->GetID());
	} else if(srcid == smenu->back->GetID()) {
		show_menu();
	} else if(srcid == back_to_menu->GetID() ||
			srcid == back_to_menu1->GetID()) {
		select_replay = false;
		show_menu();
	} else if(srcid == play_replay->GetID()) {
		if(replay_files.size())
			select_replay = true;
	} else if(srcid == unicorn->GetID()) {
		start_pressed = true;
		char_type = creature::unicorn;
	} else if(srcid == minotaur->GetID()) {
		start_pressed = true;
		char_type = creature::minotaur;
	} else if(srcid == griffin->GetID()) {
		start_pressed = true;
		char_type = creature::griffin;
	}
}

#ifdef WIN32
 #define WINDOWS
#elif WIN64
 #define WINDOWS
#endif

#ifdef WINDOWS
#include <shellapi.h>

#include <windows.h>

void main_menu::open_page(std::string url)
{
	ShellExecute(NULL, "open", url.c_str(),
			NULL, NULL, SW_SHOWNORMAL);
}
#else

void main_menu::open_page(std::string url)
{
	std::string s("xdg-open ");
	s += url;
	system(s.c_str());
}

#endif

