/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _MAINMENU_H
#define _MAINMENU_H

#include "dir.h"
#include "gui.h"
#include "creature.h"
#include "settings.h"
#include "config.h"
#include "settingsmenu.h"

class main_menu : public Gui::ActionListener {
	public:
		main_menu();
		~main_menu();

		Gui::Container *window;
		bool quit() { return quit_pressed; }
		bool start_game();
		creature::creature_type get_character() { return char_type; }
		std::string replay();

		// events
		void ButtonClick(Gui::ID srcid);
		static void set_button(Gui::Button*);
	private:
		void hide_menu();
		void show_menu();
		void open_page(std::string url);

		bool quit_pressed;
		bool start_pressed;
		bool select_replay;

		std::vector<std::string> replay_files;

		creature::creature_type char_type;

		settings_menu *smenu;

		Gui::VerticalList *button_list;
		Gui::Button *start_button;
		Gui::Button *replay_button;
		Gui::Button *page_button;
		Gui::Button *hiscores_button;
		Gui::Button *settings_button;
		Gui::Button *quit_button;

		Gui::Container *replay_window;
		Gui::TextSelection *replay_list;
		Gui::Button *back_to_menu;
		Gui::Button *play_replay;
		
		Gui::Container *game_select_window;
		Gui::Button *unicorn;
		Gui::Button *minotaur;
		Gui::Button *griffin;
		Gui::Button *back_to_menu1;

		sf::Image select;
		sf::Image bg;
		sf::Image mythorb_logo;
		sf::Image logo;
};

#endif
