/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _MOVING_H
#define _MOVING_H

#include <SFML/System/Vector2.hpp>

#include <list>
#include "object.h"
#include <iostream>

class moving {
	public:
		moving(unsigned int mode);
		virtual ~moving() { }
		sf::Vector2f get_mv_pos() { return mv_pos; }
		void set_speed(double _speed) { speed = _speed * DT; }
		bool has_moved() { return moved; }
		void set_moved(bool _moved) { moved = _moved; }

	protected:
		double speed;
		
		void set_mv_pos(sf::Vector2f _mv_pos) { mv_pos = _mv_pos; no_moving_command_given = false; }

		unsigned int anim_mode;
		static std::map<unsigned int, std::string> anim_mode_map;

		std::vector<sf::Vector2f> get_dir_vectors();
		
		std::pair<bool, sf::Vector2f> move(world &w);
	private:
		int get_move_vector_i(sf::Vector2f pos, std::list<int> disabled_dirs = std::list<int>());
		sf::Vector2f mv_pos;
		bool no_moving_command_given;
		bool moved;
};

#endif
