/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _MUSHROOM_H
#define _MUSHROOM_H

#include <list>
#include "pauseclock.h"
#include "animationloader.h"
#include "object.h"
#include "spell.h"
#include "selectable.h"
#include "attack.h"

#ifndef NO_GRAPHICS
#include "gui.h"
#include "particle.h"
#include "laser.h"
#endif

class mushroom : public selectable {
	public:
		enum mushroom_type { 
			m_attack,
			m_spore,
			m_tank,
			m_stem
		};
	
		enum mushroom_attr {
			str,
			mana,
			dur
		};

		mushroom(animation_loader *l);
		virtual ~mushroom();

		void connect(mushroom *m);
		void disconnect(mushroom *m);
		std::list<mushroom*> &get_connections() { return connections; }
		bool is_connected(mushroom *m);

		mushroom_type get_type() { return type; }
		bool is_growing() { return growing; }

		float get_grow_time() { return grow_time; }
		float get_grow_timer() { return grow_timer.get_time(); }

		void set_grow_time(float time) { grow_time = time; }

		void set_attributes(int _str, int _dur, int _mana);
		int get_attribute(mushroom_attr attr);
		void change_modifier(int dm);
		void calculate_abilities();

		std::string type_string();
		std::string str_string();
		std::string mana_string();	
		std::string dur_string();

#ifndef NO_GRAPHICS
		virtual void draw(sf::RenderTarget &target);
		virtual void draw_attack_anim(sf::RenderTarget &, particle_engine &e);
#endif
		// begins growth
		void grow(mushroom_type);
		// upgrade happens when growth is done
		void upgrade(mushroom_type);
		void stop_upgrade();
		void update(world &w);
		void pause();
		void attack_enemy(world &w);

		void wind_damage(double rel_num, int blow_count);

		double get_spell_range() { return spell_range; }

		bool cc_tree_visited;

		virtual bool collision(const object &o) const;
		virtual bool to_removed();
		bool is_saved();
	private:
		mushroom_type type;

		attack_skill atk_skill;

		bool shoot_laser;
		sf::Vector2f laser_target;

		std::list<mushroom*> connections;

		int attributes[3];
		int attribute_modifier;

		void calculate_color();

		double energy_regen;
		double hp_regen;

		double spell_range;

		pclock dead_timer;

		// growing things
		bool growing;
		mushroom_type grow_type;
		float grow_time;
		pclock grow_timer;
		bool near_grow;

		bool saved;
};

#endif 

