/***************************************************************************
*   Copyright (C) 2010 by
*    Mika Isojärvi <bungler29@gmail.com>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef MUSICPLAYER_H_INCLUDED
#define MUSICPLAYER_H_INCLUDED

#include <string>
#include <map>

#include <SFML/Audio.hpp>

typedef std::map<std::string, std::string> playlist;
typedef std::map<std::string, std::string>::iterator playlist_iterator;

class musicplayer {
	public:
		musicplayer();
		void update();
		void set_playlist(std::string);
		void set_music(std::string, std::string);
		void set_volume(float);
		float get_volume() { return volume; }
		void stop();
		void play();
		~musicplayer();
	private:
		std::string current_music;
		std::string current_playlist;
		float volume;
		bool playing;
		std::map<std::string, playlist > playlists;
		sf::Music music;
};
#endif // MUSICPLAYER_H_INCLUDED
