/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _OBJECT_MAP_H
#define _OBJECT_MAP_H

#include <list>
#include <vector>
#include <stdexcept>
#include "object.h"
#include "settings.h"

class object_map {
	public:
		object_map(const int w, const int h);
		std::list<object*> get_objects(const object *);
		std::list<object*>& get_tile(sf::Vector2i coor) { return map.at(coor.y).at(coor.x); }
		bool collision(const object *obj);
		void remove(object *);
		void add(object *);
	
		sf::Vector2f ant_target_location();
		int ant_targets_in_area(int x, int y, int w, int h);
		
		sf::Vector2i coor_to_tile(sf::Vector2f);
		double nearest_next_border(double x, int sign, double w);
		
		bool out_of_bounds(sf::Vector2f);

		int objs_on_vector(sf::Vector2f start, sf::Vector2f end, object* dis);
		
	private:
		const int w, h;
		std::vector<std::vector<std::list<object*> > > map;
};


#endif

