/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _PARTICLE_H
#define _PARTICLE_H

#include <list>
#include <SFML/Graphics.hpp>
#include "animation.h"

class particle {
	public:
		particle() : life(0), anim(0) {}
		particle(double life, sf::Color, sf::Vector2f pos, sf::Vector2f vel = sf::Vector2f(), 
				sf::Vector2f accel = sf::Vector2f());
		
		bool dead() { return life <= 0 || pos.x >= 1300; }
		sf::Vector2f get_pos() { return pos; }

		double life;
		double max_life;
		sf::Color col;

		sf::Vector2f pos;
		sf::Vector2f vel;
		sf::Vector2f accel;
		animation *anim;
};

class particle_group;
class particle_engine {
	public:
		~particle_engine();

		void add(particle_group*);

		void draw(sf::RenderTarget &);
		void update();
	private:
		std::list<particle_group*> groups;
		typedef std::list<particle_group*>::iterator g_iter;
};

class particle_emitter;
class particle_group : public sf::Drawable {
	public:
		enum draw_mode_t {
			line,
			anim,
			point
		};

		particle_group(size_t size, particle_emitter *e, draw_mode_t mode);
		~particle_group();
		virtual void Render(sf::RenderTarget &) const;
		virtual void update();
		virtual void move();
		void add(particle p);
		
		bool dead();
	protected:
		size_t size, alive;
		std::vector<particle> particles;
		particle_emitter *emitter;
		draw_mode_t draw_mode;
};

class particle_emitter {
	public:
		particle_emitter(double rate);
		void update(particle_group &g);

		static float uniform_dist(float cent, float r);
		static float uniform_dist_r(float a, float b) 
		{ 
			return uniform_dist((a+b)/2, fabsf(a-b));
		}
		void set_maximum_age(double d) { maximum_age = d; }
		double get_age() { return age; }
		bool dead() { return age - delay_time >= maximum_age; }
		void delay(double del) { delay_time = del; }
	protected:
		virtual particle create();
	private:
		double particles;
		double rate;
		double maximum_age;
		double age;
		double delay_time;
};


#endif

