/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "popup.h"

popup::popup(Gui::Rect rect, type_t _type) :
	Gui::Window(rect, sf::Color(40, 40, 150, 210), 20,
			sf::Color(40, 40, 100, 230)),
	type(_type)
{
	DrawBG(true);

	text = new Gui::TextList(Gui::Rect(20, 10, 180, type == text_box ? 60 : 100));
	text->SetBorderWidth(0);

	listener = this;

	Add(text);
	if(type == ok) {
		button = new Gui::Button("Ok");
		button->SetCoor(Gui::Coor(GetW() / 2 - button->GetW() / 2, 150));
		button->Expand(5, 5);
		Add(button);
	} else if(type == text_box) {
		Gui::HorizontalList *list = new Gui::HorizontalList(Gui::Rect(20, 150, GetW() - 20, 30), 20);
		
		button = new Gui::Button("Submit");
		button->Expand(5, 5);
		sec_button = new Gui::Button("Cancel");
		sec_button->Expand(5, 5);

		list->Add(button)->Add(sec_button);
		Add(list);
		field = new Gui::TextField(150);
		field->SetCoor(Gui::Coor(GetW() / 2 - field->GetW() / 2, 100));
		Add(field);
		field->Focus();
	} else if(type == twobuttons) {
		Gui::HorizontalList *list = new Gui::HorizontalList(Gui::Rect(20, 150, GetW() - 20, 30), 20);
		
		button = new Gui::Button("Continue");
		button->Expand(5, 5);
		sec_button = new Gui::Button("Submit");
		sec_button->Expand(5, 5);

		list->Add(button)->Add(sec_button);
		Add(list);
	}
}

void popup::set_text(std::vector<std::string> t)
{
	text->SetText(t);
}

void popup::set_field_text(const std::string &t)
{
	if(type == text_box) 
		field->SetText(t);
}

std::string popup::get_text()
{
	if(type != text_box)
		return "";
	return field->GetText();
}

void popup::ButtonClick(Gui::ID srcid)
{
	if(type == twobuttons || type == text_box) {
		if(srcid == button->GetID())
			ret = 0;
		else
			ret = 1;
	} else {
		ret = 0;
	}

	ActionListener *l = parent->GetListener();
	if(l)
		l->ButtonClick(GetID());
}


