/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _RECORD_H
#define _RECORD_H

#include <vector>
#include <fstream>
#include <string>
#include <stdexcept>
#include <iostream>
#include "creature.h"
#include <SFML/Network/Packet.hpp>

class rec_exception : public std::logic_error {
	public:
		rec_exception(const char *what) : std::logic_error(what) {}
};

class rec_version_exception : public rec_exception {
	public:
		rec_version_exception(const char *what) : rec_exception(what) {}

};

class action {
	public:
		enum type {
			none,
			cast_spell,
			select,
			move_player,
			cc_tree_selection,
			select_id,

			type_count
		} t;

		sf::Uint32 id;
		sf::Int32 x, y;

		action();
		action(sf::Packet &in);

		void write(sf::Packet &out);
};

class record {
	public:
		struct frame {
			frame();
			frame(sf::Packet &in);
			void write(sf::Packet &out);
			sf::Uint32 time;
			std::vector<action> actions;
		};

		record() : creature_type(creature::unicorn), it(frames.begin()) {}
		record(const record&);

		void append_action(action &, sf::Uint32);
		frame &get_next_frame(sf::Uint32 time);
		void read(std::string file);
		void write(std::string file);
		std::string to_str();

		typedef std::vector<frame>::iterator frame_it;
		typedef std::vector<action>::iterator action_it;

		creature::creature_type creature_type;
	private:
		void write_packet(sf::Packet &p);
		sf::Uint32 adler32(sf::Packet &p, size_t no_read = 0);
		std::vector<frame> frames;
		std::vector<frame>::iterator it;
};

template<class T> void read_vector(sf::Packet &in, std::vector<T> &v)
{
	sf::Uint32 size;
	in >> size;
	for(unsigned int a = 0; a < size; a++) {
		v.push_back(T(in));
	}
}

template<class T> void write_vector(sf::Packet &out, std::vector<T> &t)
{
	typename std::vector<T>::iterator it;
	out << (sf::Int32)t.size();
	for(it = t.begin(); it != t.end(); it++) {
		it->write(out);
	}
}

#endif
