#include <SFML/System.hpp>
#include <SFML/Graphics.hpp>
#include <SFML/Window.hpp>
#include <iostream>
#include <sstream>

void drawGrid(sf::RenderWindow &app);

int main()
{
	sf::RenderWindow app(sf::VideoMode(1024, 768, 32), "Rectangle drawing", sf::Style::None);
	bool gridEnabled = true;
	int a = 0;

	int x1, y1, x2, y2;
	while(app.IsOpened()) {
		sf::Event event;
		while(app.GetEvent(event)) {
			if(event.Type == sf::Event::Closed) {
				app.Close();
			} else if(event.Type == sf::Event::MouseButtonPressed) {
				if(event.MouseButton.Button == sf::Mouse::Left) {
					a++;
					if(a == 3)
						a = 0;
				} else {
					gridEnabled = !gridEnabled;
				}
			} else if(event.Type == sf::Event::MouseMoved) {
				if(a == 0) {
					x1 = event.MouseMove.X;
					y1 = event.MouseMove.Y;
				} else if(a == 1) {
					x2 = event.MouseMove.X;
					y2 = event.MouseMove.Y;
				}
			}

		}

		app.Clear();

		if(gridEnabled)
			drawGrid(app);
		if(a == 0) {
			std::stringstream s;
			s << "X: " << x1 << " Y: " << y1;
			sf::String str(s.str());
			app.Draw(str);
			app.Draw(sf::Shape::Circle(x1, y1, 2.0f, sf::Color::White));
		} else if(a != 0) {
			std::stringstream s;
			s << "X: " << x1 << " Y: " << y1 << " ";
			s << "W: " << (x2 - x1) << " Y2: " << (y2 - y1);
			sf::String str(s.str());
			app.Draw(str);
			sf::Shape sh = sf::Shape::Rectangle(x1, y1, x2, y2, sf::Color::White, 4.0f, sf::Color::White);
			sh.EnableFill(false);
			app.Draw(sh);
		}
		app.Display();
		sf::Sleep(0.01f);
	}

	return 0;
}


void drawGrid(sf::RenderWindow &app)
{
	const unsigned int w = app.GetWidth();
	const unsigned int h = app.GetHeight();

	for(unsigned int x = 0; x < w; x += 100)
		app.Draw(sf::Shape::Line(x, 0, x, h, 1.0f, sf::Color::Yellow));
	for(unsigned int y = 0; y < h; y += 100)
		app.Draw(sf::Shape::Line(0, y, w, y, 1.0f, sf::Color::Yellow));
}
